/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.hibernate4;

import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.hibernate4.PluginConfiguration;
import org.specrunner.hibernate4.PluginSessionFactory;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;

public class PluginSchemaExport
extends AbstractPlugin {
    private String configuration;
    private String factory;
    private String schema;
    private boolean script = false;
    private boolean drop = true;
    private boolean export = true;

    public String getConfiguration() {
        return this.configuration;
    }

    @DontEval
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getSchema() {
        return this.schema;
    }

    @DontEval
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isScript() {
        return this.script;
    }

    public void setScript(boolean script) {
        this.script = script;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public boolean isExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Configuration cfg = PluginConfiguration.getConfiguration(context, this.getConfiguration());
        if (this.isDrop()) {
            SessionFactory sessionFactory = PluginSessionFactory.getSessionFactory(context, this.getFactory());
            this.dropSchema(context, sessionFactory);
            this.createSchema(context, sessionFactory);
        }
        try {
            new SchemaExport(cfg).create(this.isScript(), this.isExport());
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
        catch (HibernateException e) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)e);
        }
        return ENext.DEEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropSchema(IContext context, SessionFactory sf) throws PluginException {
        Session s = null;
        try {
            s = sf.openSession();
            try {
                String str = "drop schema " + this.getSchema() + " cascade";
                SQLQuery sql = s.createSQLQuery(str);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info(str);
                }
                sql.executeUpdate();
            }
            catch (Throwable e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), e);
                }
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchema(IContext context, SessionFactory sf) throws PluginException {
        Session s = null;
        try {
            s = sf.openSession();
            try {
                String str = "create schema " + this.getSchema() + " authorization dba";
                SQLQuery sql = s.createSQLQuery(str);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info(str);
                }
                sql.executeUpdate();
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

