/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.hibernate4;

import java.util.Map;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.specrunner.plugins.core.objects.AbstractPluginObject;
import org.specrunner.util.UtilLog;

public class HibernateListener
implements PreInsertEventListener,
PostInsertEventListener {
    protected Map<Class<?>, AbstractPluginObject> entities;
    protected String keyBefore;

    public HibernateListener(Map<Class<?>, AbstractPluginObject> entities) {
        this.entities = entities;
    }

    public boolean onPreInsert(PreInsertEvent event) {
        block2: {
            AbstractPluginObject pin = this.entities.get(event.getEntity().getClass());
            try {
                this.keyBefore = pin.makeKey(event.getEntity());
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block2;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void onPostInsert(PostInsertEvent event) {
        block3: {
            AbstractPluginObject pin = this.entities.get(event.getEntity().getClass());
            try {
                String keyAfter = pin.makeKey(event.getEntity());
                pin.mapObject(event.getEntity(), this.keyBefore, keyAfter);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("HibernateListener (before=" + this.keyBefore + ",after=" + keyAfter + "), bound to " + event.getEntity() + ".");
                }
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block3;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }
}

