/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.hibernate4;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.context.IDestructable;
import org.specrunner.features.IFeatureManager;
import org.specrunner.hibernate4.AbstractPluginFactory;
import org.specrunner.hibernate4.HibernateListener;
import org.specrunner.hibernate4.ISessionFactoryProvider;
import org.specrunner.hibernate4.PluginConfiguration;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;

public class PluginSessionFactory
extends AbstractPluginFactory {
    public static final String SESSION_FACTORY = "sessionFactory";
    public static final String FEATURE_CONFIGURATION = PluginSessionFactory.class.getName() + ".configuration";
    protected String configuration;
    public static final String FEATURE_TYPE = PluginSessionFactory.class.getName() + ".type";
    public static final String FEATURE_FACTORY = PluginSessionFactory.class.getName() + ".factory";
    public static final String FEATURE_METHOD = PluginSessionFactory.class.getName() + ".method";

    public String getConfiguration() {
        return this.configuration;
    }

    @DontEval
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.configuration == null) {
            fm.set(FEATURE_CONFIGURATION, (Object)this);
        }
        if (this.type == null) {
            fm.set(FEATURE_TYPE, (Object)this);
        }
        if (this.factory == null) {
            fm.set(FEATURE_FACTORY, (Object)this);
        }
        if (this.method == null) {
            fm.set(FEATURE_METHOD, (Object)this);
        }
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (this.configuration == null && this.type == null && (this.factory == null || this.method == null)) {
            throw new PluginException("Parameter 'configuration', 'type', or 'factory' and 'method' missing. In 'type' use an subtype of ISessionFactoryProvider, or choose a class in 'factory' whose 'method' is static and returns a Hibernate Configuration, or a 'configuration' by its name.");
        }
        try {
            SessionFactory sf;
            Class<?> typeInstance;
            if (this.type != null) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("SessionFactory by type: " + this.type + ".");
                }
                typeInstance = Class.forName(this.type);
                ISessionFactoryProvider conf = (ISessionFactoryProvider)typeInstance.newInstance();
                sf = conf.getSessioFactory();
            } else if (this.factory != null && this.method != null) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("SessionFactory by factory/method: " + this.factory + "." + this.method + "()");
                }
                typeInstance = Class.forName(this.factory);
                Method m = typeInstance.getMethod(this.method, new Class[0]);
                sf = (SessionFactory)m.invoke(null, new Object[0]);
            } else {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("SessionFactory by Configuration named: " + this.configuration + ".");
                }
                Configuration cfg = PluginConfiguration.getConfiguration(context, this.configuration);
                ServiceRegistry serviceRegistry = this.createServiceRegistry(cfg);
                sf = cfg.buildSessionFactory(serviceRegistry);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("SessionFactory : " + sf + ".");
                }
                this.setListeners(sf);
            }
            String str = this.getName() != null ? this.getName() : SESSION_FACTORY;
            context.saveGlobal(str, (Object)new IDestructable(){

                public Object getObject() {
                    return sf;
                }

                public void destroy() {
                    sf.close();
                }
            });
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException((Throwable)e);
        }
        return ENext.SKIP;
    }

    protected ServiceRegistry createServiceRegistry(Configuration cfg) {
        Properties properties = cfg.getProperties();
        Environment.verifyProperties((Map)properties);
        ConfigurationHelper.resolvePlaceHolders((Map)properties);
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)properties).build();
        return serviceRegistry;
    }

    protected void setListeners(SessionFactory sessionFactory) {
        EventListenerRegistry registry = (EventListenerRegistry)((SessionFactoryImpl)sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        HibernateListener listener = new HibernateListener(SRServices.getObjectManager().getEntities());
        registry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
        registry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
    }

    public static SessionFactory getSessionFactory(IContext context, String name) throws PluginException {
        String str = name != null ? name : SESSION_FACTORY;
        SessionFactory sf = (SessionFactory)context.getByName(str);
        if (sf == null) {
            throw new PluginException("Instance of '" + str + "' not found. Use " + PluginSessionFactory.class.getName() + " before.");
        }
        return sf;
    }
}

