/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.jetty;

import org.eclipse.jetty.server.Server;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginNamed;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;

public class PluginStopJetty
extends AbstractPluginNamed {
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String tmp = this.getName() != null ? this.getName() : "jettyName";
        Server server = (Server)context.getByName(tmp);
        if (server == null) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), "Server instance named '" + tmp + "' not found. See PluginStartJetty.");
            return ENext.DEEP;
        }
        try {
            server.stop();
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Jetty finished.");
            }
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
        return ENext.DEEP;
    }
}

