/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.positive;

import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.PluginGroupImpl;
import org.specrunner.plugins.type.Command;
import org.specrunner.sql.AbstractPluginDatabase;
import org.specrunner.sql.PluginConnection;
import org.specrunner.sql.PluginDatabase;
import org.specrunner.sql.PluginFilter;
import org.specrunner.sql.PluginRelease;
import org.specrunner.sql.PluginSchema;
import org.specrunner.sql.PluginSchemaLoader;
import org.specrunner.sql.PluginScripts;
import org.specrunner.sql.database.IDatabase;
import org.specrunner.sql.database.impl.DatabaseDefault;
import org.specrunner.sql.meta.ISchemaLoader;
import org.specrunner.sql.meta.impl.SchemaLoaderXOM;

public class PluginDbms
extends PluginGroupImpl {
    public static final String FEATURE_SCHEMA_LOADER = PluginDbms.class.getName() + ".schemaLoader";
    private Class<? extends ISchemaLoader> schemaLoader = SchemaLoaderXOM.class;
    public static final String FEATURE_DATABASE = PluginDbms.class.getName() + ".database";
    private Class<? extends IDatabase> database = DatabaseDefault.class;
    public static final String FEATURE_SYSTEM = PluginDbms.class.getName() + ".system";
    private String system = "org.hsqldb.jdbcDriver|jdbc:hsqldb:mem:TEST_INIT|sa|";

    public PluginDbms() {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_SCHEMA_LOADER, (Object)this);
        fm.set(FEATURE_DATABASE, (Object)this);
        fm.add(PluginSchemaLoader.FEATURE_PROVIDER, (Object)this.schemaLoader.getName());
        fm.add(PluginSchemaLoader.FEATURE_REUSE, (Object)true);
        fm.add(PluginSchema.FEATURE_SOURCE, (Object)"/sgbd.cfg.xml");
        fm.add(PluginSchema.FEATURE_REUSE, (Object)true);
        fm.add(PluginConnection.FEATURE_REUSE, (Object)true);
        fm.add(PluginDatabase.FEATURE_PROVIDER, (Object)this.database.getName());
        fm.add(PluginDatabase.FEATURE_NAME, (Object)"systemDatabase");
        fm.add(PluginDatabase.FEATURE_REUSE, (Object)true);
        fm.add(AbstractPluginDatabase.FEATURE_DATASOURCE, (Object)"systemConnection");
        fm.add(AbstractPluginDatabase.FEATURE_DATABASE, (Object)"systemDatabase");
        fm.add(PluginRelease.FEATURE_NAME, (Object)"systemDatabase");
    }

    public Class<? extends ISchemaLoader> getSchemaLoader() {
        return this.schemaLoader;
    }

    public void setSchemaLoader(Class<? extends ISchemaLoader> schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    public Class<? extends IDatabase> getDatabase() {
        return this.database;
    }

    public void setDatabase(Class<? extends IDatabase> database) {
        this.database = database;
    }

    public String getSystem() {
        return this.system;
    }

    @DontEval
    public void setSystem(String system) {
        this.system = system;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_SYSTEM, (Object)this);
        this.add((IPlugin)new PluginSchemaLoader());
        this.add((IPlugin)new PluginSchema());
        PluginConnection systemConnection = new PluginConnection();
        systemConnection.setConnection(this.system);
        systemConnection.setName("systemConnection");
        this.add((IPlugin)systemConnection);
        PluginDatabase systemDatabase = new PluginDatabase();
        systemDatabase.setName("systemDatabase");
        this.add((IPlugin)systemDatabase);
        PluginScripts drop = new PluginScripts();
        drop.setClasspathrelative(true);
        drop.setValue((Object)"/sgbd_drop.sql");
        drop.setFailsafe(Boolean.valueOf(true));
        drop.setName("systemConnection");
        this.add((IPlugin)drop);
        PluginScripts create = new PluginScripts();
        create.setClasspathrelative(true);
        create.setValue((Object)"/sgbd_final.sql");
        create.setFailsafe(Boolean.valueOf(true));
        create.setName("systemConnection");
        this.add((IPlugin)create);
        this.add((IPlugin)new PluginFilter());
        super.initialize(context);
    }
}

