/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver;

import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.parameters.core.UtilParametrized;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.AbstractPluginBrowserAware;
import org.specrunner.webdriver.IFinder;
import org.specrunner.webdriver.impl.FinderXPath;

public abstract class AbstractPluginFind
extends AbstractPluginBrowserAware {
    public static final String FEATURE_FINDER_TYPE = AbstractPluginFind.class.getName() + ".finder";
    protected String finder;
    public static final String FEATURE_FINDER_INSTANCE = AbstractPluginFind.class.getName() + ".finderInstance";
    protected IFinder finderInstance;

    public String getFinder() {
        return this.finder;
    }

    public void setFinder(String finder) {
        this.finder = finder;
    }

    public IFinder getFinderInstance() {
        return this.finderInstance;
    }

    public void setFinderInstance(IFinder finder) {
        this.finderInstance = finder;
    }

    public IFinder getFinderInstance(IContext context) throws PluginException {
        UtilParametrized.setProperties((IContext)context, (IParameterHolder)this.finderInstance, (Map)this.getParameters().getAllParameters());
        return this.finderInstance;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.finder == null) {
            fm.set(FEATURE_FINDER_TYPE, (Object)this);
        }
        if (this.finderInstance == null) {
            fm.set(FEATURE_FINDER_INSTANCE, (Object)this);
        }
        if (this.finder != null && this.finderInstance == null) {
            try {
                this.finderInstance = (IFinder)Class.forName(this.finder).newInstance();
            }
            catch (Exception e) {
                throw new PluginException("IFinder implementation not found or invalid.", (Throwable)e);
            }
        }
        if (this.finderInstance == null) {
            this.finderInstance = FinderXPath.get();
        }
        this.finderInstance.reset();
    }

    @Override
    protected void doEnd(IContext context, IResultSet result, WebDriver client) throws PluginException {
        int i;
        List<WebElement> list = this.getFinderInstance(context).find(context, result, client);
        WebElement[] elements = list.toArray(new WebElement[list.size()]);
        if (UtilLog.LOG.isInfoEnabled()) {
            for (i = 0; i < elements.length; ++i) {
                UtilLog.LOG.info((this.getActionType() instanceof Command ? "Before" : "    On") + "[" + i + "]: " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.finderInstance.resume(context) + " on " + this.asString(elements[i]));
            }
        }
        this.process(context, result, client, elements);
        if (this.getActionType() instanceof Command && UtilLog.LOG.isInfoEnabled()) {
            for (i = 0; i < elements.length; ++i) {
                UtilLog.LOG.info(" After[" + i + "]: " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.finderInstance.resume(context) + " on " + this.asString(elements[i]));
            }
        }
    }

    protected abstract void process(IContext var1, IResultSet var2, WebDriver var3, WebElement[] var4) throws PluginException;

    public String asString(WebElement element) {
        block6: {
            if (UtilLog.LOG.isDebugEnabled()) {
                try {
                    return element.getTagName() + "." + this.getText(element);
                }
                catch (Exception e) {
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                    try {
                        return element.getText();
                    }
                    catch (Exception e1) {
                        if (!UtilLog.LOG.isTraceEnabled()) break block6;
                        UtilLog.LOG.trace(e1.getMessage(), (Throwable)e1);
                    }
                }
            }
        }
        return String.valueOf(element);
    }

    protected String getText(WebElement element) {
        String tagName = element.getTagName().toLowerCase();
        boolean isText = !"input".equals(tagName) && !"textarea".equals(tagName);
        return isText ? element.getText() : element.getAttribute("value");
    }
}

