/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.FeatureManagerException;
import org.specrunner.features.IFeatureManager;
import org.specrunner.listeners.IListenerManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginScoped;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.HtmlUnitDriverLocal;
import org.specrunner.webdriver.IWebDriverFactory;
import org.specrunner.webdriver.listeners.PageListener;

public class PluginBrowser
extends AbstractPluginScoped {
    public static final String BROWSER_NAME = "browser";
    public static final String BROWSER_TYPE = "type";
    public static final String FEATURE_RECORDING = PluginBrowser.class.getName() + ".recording";
    private Boolean recording = UtilLog.LOG.isDebugEnabled();
    public static final String FEATURE_WEBDRIVER_TYPE = PluginBrowser.class.getName() + ".webdriver";
    protected String webdriver;
    public static final String FEATURE_WEBDRIVER_FACTORY = PluginBrowser.class.getName() + ".webdriverfactory";
    protected String webdriverfactory;
    public static final String FEATURE_WEBDRIVER_INSTANCE = PluginBrowser.class.getName() + ".webdriverInstance";
    protected WebDriver webdriverInstance;
    public static final String FEATURE_REUSE = PluginBrowser.class.getName() + ".reuse";
    private Boolean reuse = false;

    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public String getWebdriver() {
        return this.webdriver;
    }

    public void setWebdriver(String webdriver) {
        this.webdriver = webdriver;
    }

    public String getWebdriverfactory() {
        return this.webdriverfactory;
    }

    public void setWebdriverfactory(String webdriverfactory) {
        this.webdriverfactory = webdriverfactory;
    }

    public WebDriver getWebdriverInstance() {
        return this.webdriverInstance;
    }

    public void setWebdriverInstance(WebDriver webdriverInstance) {
        this.webdriverInstance = webdriverInstance;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public PluginBrowser() {
        this.setName(BROWSER_NAME);
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        IFeatureManager fm;
        block10: {
            block9: {
                super.initialize(context);
                fm = SRServices.getFeatureManager();
                fm.set(FEATURE_RECORDING, (Object)this);
                if (this.webdriver == null) {
                    try {
                        fm.setStrict(FEATURE_WEBDRIVER_TYPE, (Object)this);
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("WebDriver type is " + this.webdriver);
                        }
                    }
                    catch (FeatureManagerException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block9;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (this.webdriverfactory == null) {
                try {
                    fm.setStrict(FEATURE_WEBDRIVER_FACTORY, (Object)this);
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("WebDriver factory is " + this.webdriverfactory);
                    }
                }
                catch (FeatureManagerException e) {
                    if (!UtilLog.LOG.isDebugEnabled()) break block10;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.webdriverInstance == null) {
            fm.set(FEATURE_WEBDRIVER_INSTANCE, (Object)this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        fac = (IListenerManager)SRServices.get(IListenerManager.class);
        if (this.recording.booleanValue()) {
            fac.add((Object)new PageListener(this.getName()));
        } else {
            fac.remove(this.getName());
        }
        reusables = (IReuseManager)SRServices.get(IReuseManager.class);
        if (this.reuse.booleanValue()) {
            cfg = new HashMap<String, String>();
            cfg.put("webdriver", this.webdriver);
            cfg.put("webdriverfactory", this.webdriverfactory);
            cfg.put("webdriverInstance", (String)this.webdriverInstance);
            reusable = (IReusable)reusables.get((Object)this.getName());
            if (reusable != null && reusable.canReuse(cfg)) {
                reusable.reset();
                this.save(context, (WebDriver)reusable.getObject());
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Browser (" + this.getName() + ") reused.");
                }
                return ENext.DEEP;
            }
        }
        if (this.webdriver != null) {
            try {
                this.webdriverInstance = (WebDriver)Class.forName(this.webdriver).newInstance();
                if (!UtilLog.LOG.isInfoEnabled()) ** GOTO lbl43
                UtilLog.LOG.info("WebDriver of type " + this.webdriverInstance.getClass() + " created.");
            }
            catch (Exception e) {
                throw new PluginException("WebDriver implementation not found or invalid.", (Throwable)e);
            }
        } else if (this.webdriverfactory != null) {
            try {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Using  " + this.webdriverfactory + " to created WebDriver.");
                }
                this.webdriverInstance = ((IWebDriverFactory)Class.forName(this.webdriverfactory).newInstance()).create(context);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("WebDriver of type " + this.webdriverInstance.getClass() + " created by factory.");
                }
            }
            catch (Exception e) {
                throw new PluginException("IWebDriverFactory implementation not found or invalid.", (Throwable)e);
            }
        }
lbl43:
        // 5 sources

        if (this.webdriverInstance == null) {
            this.webdriverInstance = new HtmlUnitDriverLocal(true);
        }
        this.save(context, this.webdriverInstance);
        if (this.reuse.booleanValue()) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("WebDriver reuse enabled.");
            }
            reusables.put((Object)this.getName(), (Object)new AbstractReusable<WebDriver>(this.getName(), this.webdriverInstance){

                public boolean canReuse(Map<String, Object> extra) {
                    String localWebdriver = (String)extra.get("webdriver");
                    String localWebDriverFactory = (String)extra.get("webdriverfactory");
                    WebDriver localWebDriverInstance = (WebDriver)extra.get("webdriverInstance");
                    if (PluginBrowser.this.webdriver != null) {
                        return PluginBrowser.this.webdriver.equalsIgnoreCase(localWebdriver);
                    }
                    if (PluginBrowser.this.webdriverfactory != null) {
                        return PluginBrowser.this.webdriverfactory.equalsIgnoreCase(localWebDriverFactory);
                    }
                    if (PluginBrowser.this.webdriverInstance != null) {
                        return PluginBrowser.this.webdriverInstance == localWebDriverInstance;
                    }
                    return PluginBrowser.this.webdriver == null && PluginBrowser.this.webdriverfactory == null;
                }

                public void reset() {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("WebDriver recycling '" + this.getName() + "'.");
                    }
                    if (PluginBrowser.this.webdriverInstance instanceof HtmlUnitDriver) {
                        PluginBrowser.this.webdriverInstance.close();
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("WebDriver '" + this.getName() + "' windows closed.");
                        }
                    }
                }

                public void release() {
                    PluginBrowser.this.webdriverInstance.quit();
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("WebDriver '" + this.getName() + "' quit.");
                    }
                }
            });
        }
        return ENext.DEEP;
    }

    protected void save(IContext context, WebDriver driver) {
        String str = this.getName() != null ? this.getName() : BROWSER_NAME;
        String type = str + "_" + BROWSER_TYPE;
        this.saveGlobal(context, str, driver);
        this.saveGlobal(context, type, driver.getClass().getSimpleName());
    }
}

