/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.actions;

import java.util.List;
import nu.xom.Node;
import nu.xom.Nodes;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.webdriver.AbstractPluginFindSingle;

public abstract class AbstractPluginSelect
extends AbstractPluginFindSingle {
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        if (!this.isSelect(element)) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Element " + this.getFinderInstance().resume(context) + " is not a select is " + element.getClass().getName()), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
        } else {
            Node node = context.getNode();
            Nodes nodes = node.query("descendant::li | descendant::option");
            if (nodes.size() == 0) {
                nodes = new Nodes(node);
            }
            List options = element.findElements(By.xpath((String)"descendant::option"));
            int errors = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                Node current = nodes.get(i);
                String option = current.getValue();
                boolean success = false;
                for (WebElement o : options) {
                    if (!option.equals(o.getText())) continue;
                    this.doSomething(element, o);
                    success = true;
                    break;
                }
                if (success) continue;
                result.addResult((Status)Failure.INSTANCE, context.newBlock(current, (IPlugin)this), (Throwable)new PluginException("The option '" + option + "' is missing."));
                ++errors;
            }
            if (errors > 0) {
                result.addResult((Status)Failure.INSTANCE, context.newBlock(node, (IPlugin)this), (Throwable)new PluginException(errors + " option(s) is(are) missing."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            } else {
                result.addResult((Status)Success.INSTANCE, context.newBlock(node, (IPlugin)this));
            }
        }
    }

    protected boolean isSelect(WebElement element) {
        return element.getTagName().equalsIgnoreCase("select");
    }

    protected abstract void doSomething(WebElement var1, WebElement var2);
}

