/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.Iterator;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.CellAdapter;
import org.specrunner.util.xom.INodeHolder;
import org.specrunner.util.xom.RowAdapter;
import org.specrunner.util.xom.TableAdapter;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.webdriver.AbstractPluginFindSingle;
import org.specrunner.webdriver.assertions.PluginCompareDate;
import org.specrunner.webdriver.assertions.PluginCompareNode;
import org.specrunner.webdriver.assertions.PluginCompareText;
import org.specrunner.webdriver.assertions.PluginCompareUtils;

public class PluginCompareTable
extends AbstractPluginFindSingle {
    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        Node node = context.getNode();
        boolean success = this.compareTable(context, result, client, element, node);
        if (!success) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(node, (IPlugin)this), (Throwable)new PluginException("Tables do not match."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
        }
    }

    protected boolean compareTable(IContext context, IResultSet result, WebDriver client, WebElement element, Node node) throws PluginException {
        WebElement tmp;
        boolean success = true;
        Nodes tables = node.query("descendant-or-self::table");
        Node table = UtilNode.getHighest((Nodes)tables);
        if (table == null) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(node, (IPlugin)this), (Throwable)new PluginException("Table to be compared is not specified."));
            return false;
        }
        TableAdapter tableExpected = UtilNode.newTableAdapter((Node)table);
        List tablesReceived = element.findElements(By.xpath((String)"descendant-or-self::table"));
        if (tablesReceived.isEmpty()) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(table, (IPlugin)this), (Throwable)new PluginException("Expected table not present in input."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            return false;
        }
        WebElement tableReceived = (WebElement)tablesReceived.get(0);
        List tableCaptions = tableReceived.findElements(By.xpath((String)"child::caption"));
        Iterator iteCaptions = tableCaptions.iterator();
        for (CellAdapter expected : tableExpected.getCaptions()) {
            if (!iteCaptions.hasNext()) {
                result.addResult((Status)Failure.INSTANCE, context.newBlock(expected.getNode(), (IPlugin)this), (Throwable)new PluginException("Caption cells missing in received table."));
                success = false;
                continue;
            }
            WebElement received = (WebElement)iteCaptions.next();
            while (!received.isDisplayed() && iteCaptions.hasNext()) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Ignore table invisible caption:" + received);
                }
                received = (WebElement)iteCaptions.next();
            }
            if (expected.hasAttribute("ignore") || !received.isDisplayed()) continue;
            success &= this.compareTerminal((IPlugin)this, context, result, client, expected, received);
        }
        boolean visible = false;
        while (!visible && iteCaptions.hasNext()) {
            tmp = (WebElement)iteCaptions.next();
            visible = tmp.isDisplayed();
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Check visibility(" + visible + ") for " + tmp);
        }
        if (visible) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(table, (IPlugin)this), (Throwable)new PluginException("Received table has more captions than expected."));
            success = false;
        }
        List tableElements = tableReceived.findElements(By.xpath((String)"child::tr/th | child::tr/td | child::thead/tr/th | child::thead/tr/td | child::tbody/tr/th | child::tbody/tr/td"));
        Iterator iteElements = tableElements.iterator();
        for (RowAdapter rowsExpected : tableExpected.getRows()) {
            for (CellAdapter expected : rowsExpected.getCells()) {
                if (!iteElements.hasNext()) {
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(expected.getNode(), (IPlugin)this), (Throwable)new PluginException("Cell missing in received table."));
                    success = false;
                    continue;
                }
                WebElement received = (WebElement)iteElements.next();
                while (!received.isDisplayed() && iteElements.hasNext()) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Ignore table invisible element:" + received);
                    }
                    received = (WebElement)iteElements.next();
                }
                if (expected.hasAttribute("ignore") || !received.isDisplayed()) continue;
                success &= this.compareTerminal((IPlugin)this, context, result, client, expected, received);
            }
        }
        visible = false;
        while (!visible && iteElements.hasNext()) {
            tmp = (WebElement)iteElements.next();
            visible = tmp.isDisplayed();
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Check visibility(" + visible + ") for " + tmp);
        }
        if (visible) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(table, (IPlugin)this), (Throwable)new PluginException("Received table has more cells than expected."));
            success = false;
        }
        return success;
    }

    protected boolean compareTerminal(IPlugin plugin, IContext context, IResultSet result, WebDriver client, CellAdapter expected, WebElement received) throws PluginException {
        if (PluginCompareTable.isTable((INodeHolder)expected)) {
            return this.compareTable(context, result, client, received, expected.getNode());
        }
        if (PluginCompareDate.isDate((INodeHolder)expected)) {
            PluginCompareDate compare = (PluginCompareDate)UtilPlugin.create((IContext)context, PluginCompareDate.class, (Element)((Element)expected.getNode()), (boolean)true);
            Object tmp = this.getValue(compare.getValue() != null ? compare.getValue() : expected.getValue(), compare.isEval(), context);
            String exp = String.valueOf(tmp);
            if (!expected.getValue().equals(exp)) {
                expected.append("{" + exp + "}");
            }
            String rec = received.getText();
            return PluginCompareUtils.compareDate(compare, exp, rec, context.newBlock(expected.getNode(), plugin), context, result, client);
        }
        if (PluginCompareNode.isNode((INodeHolder)expected)) {
            PluginCompareNode compare = (PluginCompareNode)UtilPlugin.create((IContext)context, PluginCompareNode.class, (Element)((Element)expected.getNode()), (boolean)true);
            return PluginCompareUtils.compareNode(compare, (Element)expected.getNode(), received, context.newBlock(expected.getNode(), plugin), context, result, client);
        }
        PluginCompareText compare = (PluginCompareText)UtilPlugin.create((IContext)context, PluginCompareText.class, (Element)((Element)expected.getNode()), (boolean)true);
        Object tmp = this.getValue(compare.getValue() != null ? compare.getValue() : expected.getValue(), compare.isEval(), context);
        String exp = String.valueOf(tmp);
        if (!expected.getValue().equals(exp)) {
            expected.append("{" + exp + "}");
        }
        String rec = received.getText();
        return PluginCompareUtils.compare(compare.getNormalized(exp), compare.getNormalized(rec), context.newBlock(expected.getNode(), plugin), context, result, client);
    }

    public static boolean isTable(INodeHolder holder) {
        return holder.attributeEquals("type", "table");
    }
}

