/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.listeners;

import java.util.HashMap;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.openqa.selenium.WebDriver;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.listeners.core.AbstractPluginListener;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Detail;
import org.specrunner.result.status.Failure;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.webdriver.AbstractPluginBrowserAware;

public class PageListener
extends AbstractPluginListener {
    private final Map<String, Object> info = new HashMap<String, Object>();
    private final String name;

    public PageListener(String name) {
        this.name = name;
        this.info.put("name", "(" + name + ")");
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
    }

    public void onAfterEnd(IPlugin plugin, IContext context, IResultSet result) {
        IPlugin p = context.getPlugin();
        if (p instanceof AbstractPluginBrowserAware) {
            String browserName;
            String tmp = (String)p.getParameters().getParameter("name");
            String string = browserName = tmp != null ? tmp : "browser";
            if (this.name.equals(browserName)) {
                WebDriver client = (WebDriver)context.getByName(browserName);
                if (client == null) {
                    result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Browser instance named '" + browserName + "' not created. See PluginBrowser."));
                    return;
                }
                if (context.getNode() != null) {
                    ParentNode view = (ParentNode)context.getNode();
                    Element ele = new Element("span");
                    UtilNode.setIgnore((Node)ele);
                    view.appendChild((Node)ele);
                    result.addResult((Status)Detail.INSTANCE, context.newBlock((Node)ele, p), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable(this.info, (Object)client));
                }
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PageListener other = (PageListener)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

