/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.dumper.core.ConstantsDumperFile;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.UtilIO;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.webdriver.IHtmlUnitDriver;

public abstract class AbstractPluginBrowserAware
extends AbstractPluginValue {
    public static final String FEATURE_INTERVAL = AbstractPluginBrowserAware.class.getName() + ".interval";
    private static final Long DEFAULT_INTERVAL = 100L;
    private Long interval = DEFAULT_INTERVAL;
    public static final String FEATURE_MAXWAIT = AbstractPluginBrowserAware.class.getName() + ".maxwait";
    private static final Long DEFAULT_MAXWAIT = 1000L;
    private Long maxwait = DEFAULT_MAXWAIT;
    private static final int TO_SECONDS = 1000;
    public static final String FEATURE_WAITFOR = AbstractPluginBrowserAware.class.getName() + ".waitfor";
    private String waitfor;
    public static final String FEATURE_TIMEOUT = AbstractPluginBrowserAware.class.getName() + ".timeout";
    public static final String FEATURE_DIR = AbstractPluginBrowserAware.class.getName() + ".dir";
    private String dir;
    private String download;

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public Long getMaxwait() {
        return this.maxwait;
    }

    public void setMaxwait(Long maxwait) {
        this.maxwait = maxwait;
    }

    public String getWaitfor() {
        return this.waitfor;
    }

    public void setWaitfor(String waitfor) {
        this.waitfor = waitfor;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDownload() {
        return this.download;
    }

    public void setDownload(String download) {
        this.download = download;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_INTERVAL, (Object)this);
        fm.set(FEATURE_MAXWAIT, (Object)this);
        fm.set(FEATURE_WAITFOR, (Object)this);
        fm.set(FEATURE_TIMEOUT, (Object)this);
        fm.set(FEATURE_DIR, (Object)this);
    }

    public void doEnd(IContext context, IResultSet result) throws PluginException {
        String tmp = this.getBrowserName();
        WebDriver client = (WebDriver)context.getByName(tmp);
        if (client == null) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Browser instance named '" + tmp + "' not created. See PluginBrowser."));
            return;
        }
        if (this.isWaitForClient()) {
            this.waitForClient(client);
        }
        this.doEnd(context, result, client);
        if (this.download != null) {
            this.saveDownload(context, result, client);
        }
    }

    private void saveDownload(IContext context, IResultSet result, WebDriver client) throws PluginException {
        WebClient wc;
        WebWindow window;
        if (client instanceof IHtmlUnitDriver && (window = (wc = ((IHtmlUnitDriver)client).getWebClient()).getCurrentWindow()) != null) {
            Page tmp = window.getEnclosedPage();
            if (tmp instanceof UnexpectedPage) {
                WebResponse response = tmp.getWebResponse();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Binary file: " + response.getContentType());
                }
                UnexpectedPage up = (UnexpectedPage)tmp;
                IFeatureManager fm = SRServices.getFeatureManager();
                File outputDirectory = this.dir != null ? new File(this.dir) : (File)fm.get((Object)ConstantsDumperFile.FEATURE_OUTPUT_DIRECTORY);
                File outputFile = new File(outputDirectory, this.download);
                File outputParent = outputFile.getAbsoluteFile().getParentFile();
                if (!outputParent.exists() && !outputParent.mkdirs()) {
                    throw new PluginException("Could not create binary target directory:" + outputParent.getAbsolutePath());
                }
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Download file to '" + outputFile.getAbsolutePath() + "'.");
                }
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    in = up.getInputStream();
                    out = new FileOutputStream(outputFile);
                    UtilIO.writeTo((InputStream)in, (OutputStream)out);
                }
                catch (FileNotFoundException e) {
                    throw new PluginException((Throwable)e);
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        throw new PluginException((Throwable)e);
                    }
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (IOException e) {
                        throw new PluginException((Throwable)e);
                    }
                }
                Node node = context.getNode();
                if (node instanceof Element) {
                    Element span = new Element("span");
                    UtilNode.setIgnore((Node)span);
                    span.addAttribute(new Attribute("class", "binary"));
                    span.appendChild(" [");
                    Element a = new Element("a");
                    a.addAttribute(new Attribute("href", outputFile.getAbsolutePath()));
                    a.appendChild(outputFile.getName() + " (" + response.getContentType() + ")");
                    span.appendChild((Node)a);
                    span.appendChild("] ");
                    Element e = (Element)node;
                    e.appendChild((Node)span);
                }
            }
            try {
                window.getHistory().back();
            }
            catch (IOException e) {
                throw new PluginException((Throwable)e);
            }
        }
    }

    public String getBrowserName() {
        return this.getName() != null ? this.getName() : "browser";
    }

    protected abstract void doEnd(IContext var1, IResultSet var2, WebDriver var3) throws PluginException;

    protected boolean isWaitForClient() {
        return true;
    }

    protected void waitForClient(WebDriver client) {
        if (this.getWait() == null) {
            new WebDriverWait(client, this.maxwait / 1000L, this.interval.longValue()).until(this.getWaitCondition(System.currentTimeMillis(), this.getTimeout()));
        }
    }

    protected ExpectedCondition<?> getWaitCondition(long start, Long timeout) {
        if (this.waitfor != null) {
            return ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)this.waitfor));
        }
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                if (d instanceof IHtmlUnitDriver) {
                    WebClient client = ((IHtmlUnitDriver)d).getWebClient();
                    long time = System.currentTimeMillis();
                    int count = client.waitForBackgroundJavaScript(AbstractPluginBrowserAware.this.interval.longValue());
                    while (count > 0 && System.currentTimeMillis() - time <= AbstractPluginBrowserAware.this.maxwait) {
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info(count + " threads, waiting for " + AbstractPluginBrowserAware.this.interval + "mls on max of " + AbstractPluginBrowserAware.this.maxwait + "mls.");
                        }
                        count = client.waitForBackgroundJavaScript(AbstractPluginBrowserAware.this.interval.longValue());
                    }
                    return true;
                }
                return true;
            }
        };
    }
}

