/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.webdriver.AbstractPluginFind;

public abstract class AbstractPluginCheckable
extends AbstractPluginFind {
    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement[] elements) throws PluginException {
        boolean error = false;
        for (WebElement element : elements) {
            if (this.isCheckbox(element) || this.isRadio(element)) {
                boolean componentStatus = element.isSelected();
                if (this.expected() == componentStatus) continue;
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Element " + this.getFinderInstance().resume(context) + " should be '" + (this.expected() ? "checked" : "unchecked") + "' but is '" + (componentStatus ? "checked" : "unchecked") + "'."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
                error = true;
                continue;
            }
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Element " + this.getFinderInstance().resume(context) + " is not a checkbox or radio is " + element.getTagName()), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            error = true;
        }
        if (!error) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
    }

    protected abstract boolean expected();

    protected boolean isRadio(WebElement element) {
        return "input".equals(element.getTagName()) && "radio".equals(element.getAttribute("type"));
    }

    protected boolean isCheckbox(WebElement element) {
        return "input".equals(element.getTagName()) && "checkbox".equals(element.getAttribute("type"));
    }
}

