/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.List;
import nu.xom.Nodes;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.webdriver.AbstractPluginFindSingle;

public abstract class AbstractPluginSelection
extends AbstractPluginFindSingle {
    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        if (this.isSelect(element)) {
            if (this.checkSelection(context, result, client, element) == 0) {
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
            }
        } else {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Element on " + this.getFinderInstance().resume(context) + " is not a select is " + element.getClass().getName()), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
        }
    }

    protected boolean isSelect(WebElement element) {
        return element.getTagName().equalsIgnoreCase("select");
    }

    protected abstract int checkSelection(IContext var1, IResultSet var2, WebDriver var3, WebElement var4) throws PluginException;

    protected int testList(IContext context, IResultSet result, WebDriver client, Nodes nodes, List<WebElement> options, Boolean content) {
        int i;
        int error = 0;
        String[] expecteds = new String[nodes.size()];
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            expecteds[i2] = this.getNormalized(nodes.get(i2).getValue());
        }
        String[] receiveds = new String[options.size()];
        for (i = 0; i < receiveds.length; ++i) {
            receiveds[i] = this.getNormalized(options.get(i).getText());
        }
        if (expecteds.length != receiveds.length) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Number of itens (" + receiveds.length + ") in " + (content != null && content != false ? "content" : "selected") + " is different from expected ones (" + expecteds.length + ")."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            error = 1;
        } else {
            for (i = 0; i < expecteds.length; ++i) {
                if (expecteds[i].equals(receiveds[i])) continue;
                result.addResult((Status)Failure.INSTANCE, context.newBlock(nodes.get(i), (IPlugin)this), (Throwable)new DefaultAlignmentException(expecteds[i], receiveds[i]){

                    public String getMessage() {
                        return "Selection options are diferent (" + super.getMessage() + ").";
                    }
                });
                ++error;
            }
            if (error > 0) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("The element(s) expected and received do(es) not match."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            }
        }
        return error;
    }
}

