/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.actions;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.webdriver.AbstractPluginFind;

public abstract class AbstractPluginCheck
extends AbstractPluginFind {
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement[] elements) throws PluginException {
        boolean success = true;
        for (int i = 0; i < elements.length; ++i) {
            WebElement e = elements[i];
            if (!this.isCheckbox(e)) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Element " + e + " is not a checkbox."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
                success = false;
                break;
            }
            this.doSomething(e);
        }
        if (success) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
    }

    protected boolean isCheckbox(WebElement element) {
        return "input".equals(element.getTagName()) && "checkbox".equals(element.getAttribute("type"));
    }

    protected abstract void doSomething(WebElement var1);
}

