/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.actions;

import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.webdriver.AbstractPluginFindSingle;
import org.specrunner.webdriver.IFinder;

public class PluginDragAndDrop
extends AbstractPluginFindSingle {
    private String target;
    private Integer xoffset;
    private Integer yoffset;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Integer getXoffset() {
        return this.xoffset;
    }

    public void setXoffset(Integer xoffset) {
        this.xoffset = xoffset;
    }

    public Integer getYoffset() {
        return this.yoffset;
    }

    public void setYoffset(Integer yoffset) {
        this.yoffset = yoffset;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        if (this.getTarget() == null && this.getXoffset() == null && this.getYoffset() == null) {
            throw new PluginException("To use drag and drop you should specify 'target' attribute using the same syntax of attribute 'by', or specify 'xoffset' and 'yoffset' attributes.");
        }
        Action ac = null;
        if (this.getTarget() != null) {
            IFinder finder = this.getFinderInstance();
            try {
                finder.getParameters().setParameter("by", (Object)this.getTarget(), context);
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
            List<WebElement> list = finder.find(context, result, client);
            if (list.isEmpty()) {
                throw new PluginException("Element " + finder.resume(context) + " not found.");
            }
            WebElement destination = list.get(0);
            ac = new Actions(client).dragAndDrop(element, destination).build();
        } else if (this.getXoffset() == null && this.getYoffset() == null) {
            ac = new Actions(client).dragAndDropBy(element, this.getXoffset().intValue(), this.getYoffset().intValue()).build();
        } else {
            throw new PluginException("You should specify both 'xoffset' and 'yoffset' attributes.");
        }
        ac.perform();
        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
    }
}

