/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.LinkedList;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.string.IStringNormalizer;
import org.specrunner.util.string.UtilString;
import org.specrunner.webdriver.assertions.PluginCompareDate;
import org.specrunner.webdriver.assertions.PluginCompareNode;

public final class PluginCompareUtils {
    private PluginCompareUtils() {
    }

    public static boolean compare(String expected, String received, IBlock block, IContext context, IResultSet result, WebDriver client) throws PluginException {
        boolean res = true;
        if (expected.equals(received)) {
            result.addResult((Status)Success.INSTANCE, block);
        } else {
            PluginCompareUtils.addError(expected, received, block, context, result, client);
            res = false;
        }
        return res;
    }

    protected static void addError(String expected, String received, IBlock block, IContext context, IResultSet result, WebDriver client) throws PluginException {
        try {
            if (client == null) {
                result.addResult((Status)Failure.INSTANCE, block, (Throwable)new DefaultAlignmentException(expected, received));
            } else {
                result.addResult((Status)Failure.INSTANCE, block, (Throwable)new DefaultAlignmentException(expected, received), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException((Throwable)e);
        }
    }

    public static boolean compareDate(PluginCompareDate compare, String expected, String received, IBlock block, IContext context, IResultSet result, WebDriver client) throws PluginException {
        boolean res = true;
        DateTimeFormatter fmt = null;
        try {
            fmt = DateTimeFormat.forPattern((String)compare.getFormat());
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            result.addResult((Status)Failure.INSTANCE, block, (Throwable)new PluginException((Throwable)e));
            res = false;
        }
        if (fmt != null) {
            try {
                DateTime dtExpected = fmt.parseDateTime(expected);
                DateTime dtReceived = fmt.parseDateTime(received);
                if (Math.abs(dtExpected.getMillis() - dtReceived.getMillis()) <= compare.getTolerance()) {
                    result.addResult((Status)Success.INSTANCE, block);
                } else {
                    PluginCompareUtils.addError(expected, received, block, context, result, client);
                    res = false;
                }
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                PluginCompareUtils.addError(expected, received, block, context, result, client);
            }
        }
        return res;
    }

    public static boolean compareNode(PluginCompareNode compare, Element expected, WebElement received, IBlock block, IContext context, IResultSet result) {
        int errors = PluginCompareUtils.compareTexts(compare, context, result, expected, received, 0);
        Nodes expChildren = expected.query("descendant::*");
        LinkedList<WebElement> recChildren = received.findElements(By.xpath((String)"descendant::*"));
        LinkedList<WebElement> visible = new LinkedList<WebElement>();
        for (WebElement we : recChildren) {
            if (!we.isDisplayed()) continue;
            visible.add(we);
        }
        recChildren = visible;
        int min = Math.min(expChildren.size(), recChildren.size());
        for (int i = 0; i < min; ++i) {
            errors = PluginCompareUtils.compareElements(compare, context, result, (Element)expChildren.get(i), (WebElement)recChildren.get(i), errors);
        }
        int max = Math.max(expChildren.size(), recChildren.size());
        boolean onExpected = max == expChildren.size();
        for (int i = min; i < max; ++i) {
            ++errors;
            if (onExpected) {
                result.addResult((Status)Failure.INSTANCE, context.newBlock(expChildren.get(i), (IPlugin)compare), (Throwable)new PluginException("Missing element."));
                continue;
            }
            result.addResult((Status)Failure.INSTANCE, context.newBlock((Node)expected, (IPlugin)compare), (Throwable)new PluginException("Extra element on screen."));
        }
        if (errors == 0) {
            result.addResult((Status)Success.INSTANCE, block);
        }
        return errors == 0;
    }

    protected static int compareTexts(PluginCompareNode compare, IContext context, IResultSet result, Element expected, WebElement received, int errors) {
        String strReceived;
        IStringNormalizer sn = UtilString.getNormalizer();
        String strExpected = sn.normalize(expected.getValue());
        if (!strExpected.equals(strReceived = sn.normalize(received.getText()))) {
            ++errors;
            result.addResult((Status)Failure.INSTANCE, context.newBlock((Node)expected, (IPlugin)compare), (Throwable)new DefaultAlignmentException(strExpected, strReceived));
        }
        return errors;
    }

    protected static int compareElements(PluginCompareNode compare, IContext context, IResultSet result, Element e, WebElement we, int errors) {
        errors = PluginCompareUtils.compareTexts(compare, context, result, e, we, errors);
        if (!e.getLocalName().equalsIgnoreCase(we.getTagName())) {
            ++errors;
            result.addResult((Status)Failure.INSTANCE, context.newBlock((Node)e, (IPlugin)compare), (Throwable)new PluginException("Tag names do not match (expected: '" + e.getLocalName() + "', received: '" + we.getTagName() + "'."));
        }
        for (int j = 0; j < e.getAttributeCount(); ++j) {
            boolean match;
            Attribute att = e.getAttribute(j);
            String name = att.getLocalName();
            String attExp = e.getAttributeValue(name);
            String attRec = we.getAttribute(name);
            if (attRec == null) {
                ++errors;
                result.addResult((Status)Failure.INSTANCE, context.newBlock((Node)e, (IPlugin)compare), (Throwable)new PluginException("Attribute '" + name + "' missing (expected: '" + name + "=" + attExp + "')."));
                continue;
            }
            String attRecNorm = compare.getNormalized(attRec);
            String attExpNorm = compare.getNormalized(attExp);
            boolean bl = match = compare.getContains() != false && attRecNorm.contains(attExpNorm) || attExpNorm.equals(attRecNorm);
            if (match) continue;
            ++errors;
            result.addResult((Status)Failure.INSTANCE, context.newBlock((Node)e, (IPlugin)compare), (Throwable)new PluginException("Attribute '" + name + "' does not match (expected: '" + attExp + "', received: '" + attRec + "')."));
        }
        return errors;
    }
}

