/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.webdriver.AbstractPluginFind;
import org.specrunner.webdriver.IFinder;

public class PluginPresent
extends AbstractPluginFind {
    private Integer count;
    private Integer min;
    private Integer max;

    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    protected void doEnd(IContext context, IResultSet result, WebDriver client) throws PluginException {
        IFinder finder = this.getFinderInstance(context);
        List<WebElement> list = finder.find(context, result, client);
        this.printBefore(context, list);
        int failure = 0;
        if (this.getCount() != null) {
            if (list.size() != this.getCount().intValue()) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("The expected count of elements was '" + this.count + "', but '" + list.size() + "' was received."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
                ++failure;
            }
        } else if (list.isEmpty()) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Element not found."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
            ++failure;
        }
        if (this.getMin() != null && list.size() < this.getMin()) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("The expected minimum of elements was '" + this.count + "', but '" + list.size() + "' was received."));
            ++failure;
        }
        if (this.getMax() != null && list.size() > this.getMax()) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("The expected maximum of elements was '" + this.count + "', but '" + list.size() + "' was received."));
            ++failure;
        }
        if (failure == 0) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement[] elements) throws PluginException {
    }
}

