/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.context.IContext;
import org.specrunner.parameters.core.ParameterHolder;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IFinder;

public class FinderXPath
extends ParameterHolder
implements IFinder {
    private static ThreadLocal<FinderXPath> instance = new ThreadLocal<FinderXPath>(){

        @Override
        protected FinderXPath initialValue() {
            return new FinderXPath();
        }
    };
    private final Map<String, String> strategies = new HashMap<String, String>();
    protected String by;
    protected String separator = ";";

    protected FinderXPath() {
        this.addStrategy("id", "//*[@id='{0}']");
        this.addStrategy("name", "//*[@name='{0}']");
        this.addStrategy("value", "//*[@value='{0}']");
        this.addStrategy("class", "//{0}[contains(@class,'{1}')]");
        this.addStrategy("contains", "//{0}[contains(.,'{1}')]");
        this.addStrategy("starts", "//{0}[starts-with({1},'{2}')]");
        this.addStrategy("ends", "//{0}[ends-with({1},'{2}')]");
        this.addStrategy("link", "//a[text()='{0}']");
        this.addStrategy("linkText", "//a[text()='{0}']");
        this.addStrategy("partialLinkText", "//a[contains(text(),'{0}')]");
        this.addStrategy("caption", "//table/caption[contains(text(),'{0}')]/..");
        this.addStrategy("xpath", "{0}");
    }

    public static FinderXPath get() {
        return instance.get();
    }

    public Iterator<String> getStrategies() {
        return this.strategies.keySet().iterator();
    }

    public void addStrategy(String name, String xpath) {
        this.strategies.put(name, xpath);
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Search strategy (" + name + "," + xpath + ") added.");
        }
    }

    public String findStrategy(String name) {
        return this.strategies.get(name);
    }

    public String getBy() {
        return this.by;
    }

    public void setBy(String by) {
        this.by = by;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getType() {
        if (this.by == null) {
            return null;
        }
        int pos = this.by.indexOf(58);
        if (pos > 0) {
            return this.by.substring(0, pos);
        }
        return this.by;
    }

    public String[] getArguments(IContext context) {
        if (this.by == null) {
            return null;
        }
        int pos = this.by.indexOf(58);
        String value = this.by;
        if (pos > 0) {
            value = this.by.substring(pos + 1);
            if (value.isEmpty() || value.endsWith(this.getSeparator())) {
                value = value + context.getNode().getValue();
            }
            return value.split(this.getSeparator());
        }
        value = context.getNode().getValue();
        return value.split(this.getSeparator());
    }

    @Override
    public String getXPath(IContext context) throws PluginException {
        String format = this.findStrategy(this.getType());
        if (format == null) {
            throw new PluginException("Invalid search strategy '" + this.getType() + "', see FindeXPath to see options, or registry your pattern using FindeXPath.get().addStrategy(<type>,<pattern>). i.e. if you add FindeXPath.addStrategy(\"class\",\"//*[contains(@class,'${0}')]\") means you can now use 'by=class:any_css'.");
        }
        String[] args = this.getArguments(context);
        for (int i = 0; i < args.length; ++i) {
            format = format.replace("{" + i + "}", args[i]);
        }
        return format;
    }

    @Override
    public void reset() {
        this.by = null;
    }

    @Override
    public List<WebElement> find(IContext context, IResultSet result, WebDriver client) throws PluginException {
        if (this.by == null) {
            throw new PluginException("Element missing search strategy, use, for instance, the attribute by='id:txtName'.");
        }
        String type = this.getType();
        String xpath = this.getXPath(context);
        List list = null;
        try {
            list = client.findElements(By.xpath((String)xpath));
        }
        catch (Exception e) {
            throw new PluginException("Element " + type + " '" + xpath + "' not found.", (Throwable)e);
        }
        if (list == null) {
            throw new PluginException("Use \"by='<type>:<argument>'\" to select the element.");
        }
        return list;
    }

    @Override
    public String resume(IContext context) throws PluginException {
        return "strategy: by " + this.getBy() + " with XPath " + this.getXPath(context);
    }
}

