/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import java.io.File;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IWebDriverFactory;

public class WebDriverFactoryChrome
implements IWebDriverFactory {
    public static final String FEATURE_CHROME = WebDriverFactoryChrome.class.getName() + ".chrome";
    protected String chrome;
    public static final String FEATURE_DRIVER = WebDriverFactoryChrome.class.getName() + ".driver";
    protected String driver;
    public static final String FEATURE_SWITCHES = WebDriverFactoryChrome.class.getName() + ".switches";
    protected String switches;

    public WebDriverFactoryChrome() {
        String path = System.getProperty("user.home") + "/AppData/Local/Google/Chrome/Application/";
        this.chrome = path + "chrome.exe";
        this.driver = path + "chromedriver.exe";
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_CHROME, (Object)this);
        fm.set(FEATURE_DRIVER, (Object)this);
        fm.set(FEATURE_SWITCHES, (Object)this);
    }

    public String getChrome() {
        return this.chrome;
    }

    public void setChrome(String chrome) {
        this.chrome = chrome;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getSwitches() {
        return this.switches;
    }

    public void setSwitches(String switches) {
        this.switches = switches;
    }

    @Override
    public WebDriver create(String name, IContext context) throws PluginException {
        File fChrome;
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Factory:" + this.getClass());
        }
        if (!(fChrome = new File(this.chrome)).exists()) {
            throw new PluginException("Missing Chrome application at:" + fChrome + ". Download Chrome and/or set 'FEATURE_CHROME' feature to the application executable.");
        }
        File fDriver = new File(this.driver);
        if (!fDriver.exists()) {
            throw new PluginException("Missing Chrome driver at Chrome path:" + fDriver + ". Download 'chromedriver.exe' at http://chromium.googlecode.com/ and set 'FEATURE_DRIVER' to the executable.");
        }
        System.setProperty("webdriver.chrome.driver", fDriver.getAbsolutePath());
        ChromeOptions options = new ChromeOptions();
        options.setBinary(fChrome);
        if (this.switches != null) {
            options.addArguments(new String[]{this.switches});
        }
        return new ChromeDriver(options);
    }
}

