/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl.htmlunit;

import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.specrunner.SRServices;
import org.specrunner.features.IFeatureManager;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.impl.htmlunit.CacheableMime;
import org.specrunner.webdriver.impl.htmlunit.ICacheable;
import org.specrunner.webdriver.impl.htmlunit.IWebConnection;

public class WebConnectionFile
extends HttpWebConnection
implements IWebConnection {
    public static final String FEATURE_DIRECTORY = WebConnectionFile.class.getName() + ".cacheDirectory";
    protected File cacheDirectory = new File("src/test/resources/outcome/cache");
    public static final String FEATURE_CLEAN = WebConnectionFile.class.getName() + ".cacheClean";
    protected Boolean cacheClean;
    public static final String FEATURE_STRATEGY = WebConnectionFile.class.getName() + ".strategy";
    protected String strategy;
    protected ICacheable strategyInstance = new CacheableMime();
    private MessageDigest digest;

    public WebConnectionFile(WebClient webClient) {
        super(webClient);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_DIRECTORY, (Object)this);
        if (this.cacheClean == null) {
            fm.set(FEATURE_CLEAN, (Object)this);
        }
        if (this.cacheClean != null && this.cacheClean.booleanValue()) {
            this.reset();
        }
        if (this.strategy == null) {
            fm.set(FEATURE_STRATEGY, (Object)this);
        }
        if (this.strategy != null) {
            try {
                this.strategyInstance = (ICacheable)Class.forName(this.strategy).newInstance();
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public Boolean getCacheClean() {
        return this.cacheClean;
    }

    public void setCacheClean(Boolean cacheClean) {
        this.cacheClean = cacheClean;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    @Override
    public void reset() {
        if (!this.cacheDirectory.exists() && !this.cacheDirectory.mkdirs()) {
            throw new RuntimeException("Could not create cache directory '" + this.cacheDirectory + "'.");
        }
        for (File f : this.cacheDirectory.listFiles()) {
            if (f.delete()) {
                if (!UtilLog.LOG.isInfoEnabled()) continue;
                UtilLog.LOG.info("Cache file '" + f + "' deleted.");
                continue;
            }
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Cache file '" + f + "' could not be delete.");
        }
    }

    public WebResponse getResponse(WebRequest request) throws IOException {
        File file = this.asFile(request);
        WebResponse response = this.get(file);
        if (response == null) {
            response = super.getResponse(request);
            if (this.strategyInstance.isCacheable(request, response)) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Save to cache (loaded in " + response.getLoadTime() + " mls): " + request.getUrl());
                }
                this.save(request, response, file);
            }
        } else if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Loaded from cache: " + request.getUrl());
        }
        return response;
    }

    protected File asFile(WebRequest request) {
        this.digest.reset();
        this.digest.update(request.getUrl().toString().getBytes());
        BigInteger i = new BigInteger(1, this.digest.digest());
        String name = String.valueOf(i).replace(",", "");
        File result = new File(this.cacheDirectory, name);
        result.getParentFile().mkdirs();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebResponse get(File file) throws IOException {
        WebResponse result = null;
        ObjectInputStream oin = null;
        try {
            if (file.exists()) {
                long time = System.currentTimeMillis();
                oin = new ObjectInputStream(new FileInputStream(file));
                result = (WebResponse)oin.readObject();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("File loaded in " + (System.currentTimeMillis() - time) + " mls.");
                }
            }
        }
        catch (ClassNotFoundException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            block16: {
                if (oin != null) {
                    try {
                        oin.close();
                    }
                    catch (Exception e) {
                        if (!UtilLog.LOG.isTraceEnabled()) break block16;
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(WebRequest request, WebResponse response, File file) {
        ObjectOutputStream out = null;
        try {
            long time = System.currentTimeMillis();
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(response);
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Response saved in " + (System.currentTimeMillis() - time) + " mls.");
            }
        }
        catch (IOException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            block15: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        if (!UtilLog.LOG.isTraceEnabled()) break block15;
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

