/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver;

import java.util.Arrays;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.webdriver.AbstractPluginBrowserAware;

public abstract class AbstractPluginRotatable
extends AbstractPluginBrowserAware {
    private String orientation;

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    protected ScreenOrientation getOrientationValue() throws PluginException {
        ScreenOrientation so = ScreenOrientation.valueOf((String)this.getOrientation());
        if (so == null) {
            throw new PluginException("Invalid ScreenOrientation value '" + this.getOrientation() + "'. Valid values:" + Arrays.toString(ScreenOrientation.values()));
        }
        return so;
    }

    @Override
    protected void doEnd(IContext context, IResultSet result, WebDriver client) throws PluginException {
        if (client instanceof Rotatable) {
            this.doEnd(context, result, client, (Rotatable)client);
        } else {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("The WebDriver '" + client.getClass().getName() + "' is not a instance of Rotatable."));
        }
    }

    protected abstract void doEnd(IContext var1, IResultSet var2, WebDriver var3, Rotatable var4) throws PluginException;
}

