/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import java.io.File;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IWebDriverFactory;

public class WebDriverFactoryIe
implements IWebDriverFactory {
    public static final String FEATURE_DRIVER = WebDriverFactoryIe.class.getName() + ".driver";
    protected String driver;

    public WebDriverFactoryIe() {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_DRIVER, (Object)this);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public WebDriver create(String alias, IContext context) throws PluginException {
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Factory:" + this.getClass());
        }
        if (this.driver == null) {
            throw new PluginException("Missing IE driver path. Download 'IEDriverServer.exe' at http://code.google.com/p/selenium/downloads/list and set 'FEATURE_DRIVER' to the executable.");
        }
        File fDriver = new File(this.driver);
        if (!fDriver.exists()) {
            throw new PluginException("Missing IE driver at path:" + fDriver + ". Download 'IEDriverServer.exe' at http://code.google.com/p/selenium/downloads/list and set 'FEATURE_DRIVER' to the executable.");
        }
        System.setProperty("webdriver.ie.driver", fDriver.getAbsolutePath());
        DesiredCapabilities ieCapabilities = DesiredCapabilities.internetExplorer();
        ieCapabilities.setCapability("ignoreProtectedModeSettings", true);
        return new InternetExplorerDriver((Capabilities)ieCapabilities);
    }
}

