/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.xom.node.INodeHolder;
import org.specrunner.util.xom.node.INodeHolderFactory;
import org.specrunner.webdriver.AbstractPluginFindSingle;

public class PluginCheckAtt
extends AbstractPluginFindSingle {
    private String attribute;

    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        INodeHolder nh;
        Object value;
        String attRaw = element.getAttribute(String.valueOf(this.attribute));
        Object attName = this.getValue(attRaw, true, context);
        String attValue = element.getAttribute(String.valueOf(attName));
        if (this.test(attValue, value = (nh = ((INodeHolderFactory)SRServices.get(INodeHolderFactory.class)).newHolder(context.getNode())).getObject(context, true))) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        } else {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException(this.getMessage(context, value)), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
        }
    }

    protected boolean test(Object attValue, Object value) {
        return value == null && attValue == null || this.getNormalized(String.valueOf(attValue)).contains(this.getNormalized(String.valueOf(value)));
    }

    protected String getMessage(IContext context, Object value) throws PluginException {
        return "Element " + this.getFinderInstance().resume(context) + " does not has an attribute '" + this.attribute + "' with value '" + value + "'.";
    }
}

