/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.xom.node.INodeHolder;
import org.specrunner.util.xom.node.INodeHolderFactory;
import org.specrunner.webdriver.assertions.PluginCompareText;
import org.specrunner.webdriver.assertions.PluginCompareUtils;

public class PluginCompareDate
extends PluginCompareText {
    public static final String FEATURE_FORMAT = PluginCompareDate.class.getName() + ".format";
    private String format;
    public static final String FEATURE_TOLERANCE = PluginCompareDate.class.getName() + ".tolerance";
    private static final Long DEFAULT_TOLERANCE = 1000L;
    private Long tolerance = DEFAULT_TOLERANCE;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Long getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(Long tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.format == null) {
            fm.set(FEATURE_FORMAT, (Object)this);
        }
        fm.set(FEATURE_TOLERANCE, (Object)this);
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        String expected = this.getExpected(context);
        if (this.getFormat() == null) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Date comparison missing 'format' attribute."));
            return;
        }
        String received = this.getText(element);
        PluginCompareUtils.compareDate(this, expected, received, context.newBlock(context.getNode(), (IPlugin)this), context, result, client);
    }

    protected String getExpected(IContext context) throws PluginException {
        INodeHolder nh = ((INodeHolderFactory)SRServices.get(INodeHolderFactory.class)).newHolder(context.getNode());
        if (this.getFormat() == null) {
            this.setFormat(nh.getAttribute("for0"));
        }
        Object tmp = nh.getObject(context, true);
        String expected = null;
        if (tmp instanceof Date || tmp instanceof ReadableInstant || tmp instanceof ReadablePartial) {
            DateTime time = new DateTime(tmp);
            expected = time.toString(this.getFormat());
        } else {
            expected = String.valueOf(tmp);
        }
        return expected;
    }

    public static boolean isDate(INodeHolder holder) {
        return holder.attributeEquals("type", "date");
    }
}

