/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.HashMap;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.Node;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.comparators.IComparator;
import org.specrunner.comparators.core.ComparatorNode;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.expressions.IExpression;
import org.specrunner.expressions.IExpressionFactory;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.source.IBuilderFactory;
import org.specrunner.util.UtilLog;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.string.IStringNormalizer;
import org.specrunner.util.string.UtilString;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.util.xom.node.INodeHolder;
import org.specrunner.util.xom.node.INodeHolderFactory;
import org.specrunner.webdriver.AbstractPluginFindSingle;
import org.specrunner.webdriver.assertions.PluginCompareUtils;

public class PluginCompareNode
extends AbstractPluginFindSingle {
    private Boolean contains = false;
    private Boolean strict = false;
    private ThreadLocal<IComparator> comparator = new ThreadLocal<IComparator>(){

        @Override
        protected IComparator initialValue() {
            return new ComparatorNode();
        }
    };

    public Boolean getContains() {
        return this.contains;
    }

    public void setContains(Boolean contains) {
        this.contains = contains;
    }

    public Boolean getStrict() {
        return this.strict;
    }

    public void setStrict(Boolean strict) {
        this.strict = strict;
    }

    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        try {
            IExpressionFactory ef = SRServices.getExpressionFactory();
            IExpression e = ef.create((Object)"$NODE", context);
            Element expected = (Element)e.evaluate(context);
            if (!this.strict.booleanValue()) {
                if (!PluginCompareUtils.compareNode(this, expected, element, (IBlock)context.peek(), context, result)) {
                    result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Nodes do not match."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
                }
            } else {
                Object tmp = ((JavascriptExecutor)client).executeScript("return arguments[0].innerHTML", new Object[]{element});
                IBuilderFactory bf = (IBuilderFactory)SRServices.get(IBuilderFactory.class);
                Builder builder = bf.newBuilder(new HashMap());
                Element received = (Element)builder.build("<html><head></head><body>" + String.valueOf(tmp) + "</body></html>", null).query("//body").get(0);
                INodeHolder holder = ((INodeHolderFactory)SRServices.get(INodeHolderFactory.class)).newHolder(context.getNode());
                IComparator holderComparator = holder.getComparator(this.comparator.get());
                holderComparator.initialize();
                if (!holderComparator.match((Object)expected, (Object)received)) {
                    IStringNormalizer sn = UtilString.getNormalizer();
                    result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new DefaultAlignmentException(sn.normalize(UtilNode.getChildrenAsString((Node)expected)), sn.normalize(UtilNode.getChildrenAsString((Node)received))));
                } else {
                    result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                }
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
            throw new PluginException((Throwable)e);
        }
    }

    public static boolean isNode(INodeHolder holder) {
        return holder.attributeEquals("type", "node");
    }
}

