/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import com.gargoylesoftware.htmlunit.WebClient;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.core.ParameterHolder;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IHtmlUnitDriver;
import org.specrunner.webdriver.IWait;

public class WaitDefault
extends ParameterHolder
implements IWait {
    protected static final int TO_SECONDS = 1000;
    protected Long interval = DEFAULT_INTERVAL;
    protected Long maxwait = DEFAULT_MAXWAIT;
    protected String waitfor = DEFAULT_WAITFOR;
    protected String waitforSeparator = ";";
    protected String waitforMethodSeparator = ":";
    protected String waitforPrefix = DEFAULT_WAITFOR_PREFIX;
    protected String waitforSuffix = DEFAULT_WAITFOR_SUFFIX;

    @Override
    public void reset() {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("reset()");
        }
        this.interval = DEFAULT_INTERVAL;
        this.maxwait = DEFAULT_MAXWAIT;
        this.waitfor = DEFAULT_WAITFOR;
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_INTERVAL, (Object)this);
        fm.set(FEATURE_MAXWAIT, (Object)this);
        fm.set(FEATURE_WAITFOR, (Object)this);
        fm.set(FEATURE_WAITFOR_SEPARATOR, (Object)this);
        fm.set(FEATURE_WAITFOR_METHOD_SEPARATOR, (Object)this);
        fm.set(FEATURE_WAITFOR_PREFIX, (Object)this);
        fm.set(FEATURE_WAITFOR_SUFFIX, (Object)this);
    }

    @Override
    public Long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(Long interval) {
        this.interval = interval;
    }

    @Override
    public Long getMaxwait() {
        return this.maxwait;
    }

    @Override
    public void setMaxwait(Long maxwait) {
        this.maxwait = maxwait;
    }

    @Override
    public String getWaitfor() {
        return this.waitfor;
    }

    @Override
    public void setWaitfor(String waitfor) {
        this.waitfor = waitfor;
    }

    @Override
    public String getWaitforSeparator() {
        return this.waitforSeparator;
    }

    @Override
    public void setWaitforSeparator(String waitforSeparator) {
        this.waitforSeparator = waitforSeparator;
    }

    @Override
    public String getWaitforMethodSeparator() {
        return this.waitforMethodSeparator;
    }

    @Override
    public void setWaitforMethodSeparator(String waitforMethodSeparator) {
        this.waitforMethodSeparator = waitforMethodSeparator;
    }

    @Override
    public String getWaitforPrefix() {
        return this.waitforPrefix;
    }

    @Override
    public void setWaitforPrefix(String waitforPrefix) {
        this.waitforPrefix = waitforPrefix;
    }

    @Override
    public String getWaitforSuffix() {
        return this.waitforSuffix;
    }

    @Override
    public void setWaitforSuffix(String waitforSuffix) {
        this.waitforSuffix = waitforSuffix;
    }

    @Override
    public boolean isWaitForClient(IContext context, IResultSet result, WebDriver client) {
        return true;
    }

    @Override
    public void waitForClient(IContext context, IResultSet result, WebDriver client) throws PluginException {
        block4: {
            try {
                List<ExpectedCondition<?>> conditions = this.getWaitCondition(context, result, client);
                for (int i = 0; i < conditions.size(); ++i) {
                    ExpectedCondition<?> c = conditions.get(i);
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Wait condition[" + (i + 1) + " of " + conditions.size() + "]: " + c);
                    }
                    new WebDriverWait(client, this.maxwait / 1000L, this.interval.longValue()).until(c);
                }
            }
            catch (TimeoutException e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block4;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getWaitfor(IContext context, IResultSet result, WebDriver client) throws PluginException {
        StringBuilder sb = new StringBuilder();
        if (this.waitfor != null) {
            if (this.waitforPrefix != null) {
                sb.append(this.waitforPrefix);
                sb.append(this.waitforSeparator);
            }
            sb.append(this.waitfor);
            if (this.waitforSuffix != null) {
                sb.append(this.waitforSeparator);
                sb.append(this.waitforSuffix);
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public List<ExpectedCondition<?>> getWaitCondition(IContext context, IResultSet result, WebDriver client) throws PluginException {
        LinkedList conditions = new LinkedList();
        String test = this.getWaitfor(context, result, client);
        if (test != null) {
            StringTokenizer st = new StringTokenizer(test, this.waitforSeparator);
            while (st.hasMoreTokens()) {
                conditions.add(this.getTestWait(st.nextToken()));
            }
        } else {
            conditions.add(this.getDefaultWait());
        }
        return conditions;
    }

    protected ExpectedCondition<?> getTestWait(String test) throws PluginException {
        int pos = test.indexOf(this.getWaitforMethodSeparator());
        if (pos > 0) {
            String method = test.substring(0, pos);
            String xpath = test.substring(pos + this.getWaitforMethodSeparator().length());
            try {
                Method m = ExpectedConditions.class.getMethod(method, By.class);
                if (m == null) {
                    throw new PluginException("Method '" + method + "' not found.");
                }
                return (ExpectedCondition)m.invoke(null, By.xpath((String)xpath));
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
        }
        return ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)test));
    }

    protected ExpectedCondition<Boolean> getDefaultWait() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                if (d instanceof IHtmlUnitDriver) {
                    WebClient client = ((IHtmlUnitDriver)d).getWebClient();
                    long time = System.currentTimeMillis();
                    int count = client.waitForBackgroundJavaScript(WaitDefault.this.interval.longValue());
                    while (count > 0 && System.currentTimeMillis() - time <= WaitDefault.this.interval) {
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info(count + " threads, waiting for " + WaitDefault.this.interval + "mls on max of " + WaitDefault.this.maxwait + "mls.");
                        }
                        count = client.waitForBackgroundJavaScript(WaitDefault.this.interval.longValue());
                    }
                    return true;
                }
                return true;
            }

            public String toString() {
                return "Wait default.";
            }
        };
    }
}

