/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import nu.xom.Element;
import nu.xom.Node;
import org.openqa.selenium.WebDriver;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.parameters.core.UtilParametrized;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IWebDriverFactory;
import org.specrunner.webdriver.impl.HtmlUnitDriverLocal;

public class WebDriverFactoryHtmlUnit
implements IWebDriverFactory {
    private Boolean reuse = Boolean.FALSE;
    private HtmlUnitDriverLocal driver;

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    @Override
    public WebDriver create(String name, IContext context) {
        SRServices.getFeatureManager().set(FEATURE_REUSE, (Object)this);
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Default factory( reuse = " + this.reuse + "," + this + "):" + this.getClass());
        }
        if (this.reuse.booleanValue()) {
            if (this.driver == null) {
                this.driver = this.newInstance(name, context);
            }
        } else {
            this.driver = this.newInstance(name, context);
        }
        return this.driver;
    }

    protected HtmlUnitDriverLocal newInstance(String name, IContext context) {
        HtmlUnitDriverLocal driver;
        block3: {
            driver = new HtmlUnitDriverLocal(true);
            driver.setName(name);
            Node node = context.getNode();
            if (node instanceof Element) {
                try {
                    UtilParametrized.setProperties((IContext)context, (IParameterHolder)driver, (Element)((Element)node));
                }
                catch (PluginException e) {
                    if (!UtilLog.LOG.isInfoEnabled()) break block3;
                    UtilLog.LOG.info(e.getMessage(), (Throwable)e);
                }
            }
        }
        driver.initialize();
        return driver;
    }
}

