/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.context.IDestructable;
import org.specrunner.features.FeatureManagerException;
import org.specrunner.features.IFeatureManager;
import org.specrunner.listeners.IListenerManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginScoped;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IWebDriverFactory;
import org.specrunner.webdriver.impl.WebDriverFactoryHtmlUnit;
import org.specrunner.webdriver.listeners.PageListener;

public class PluginBrowser
extends AbstractPluginScoped {
    public static final String BROWSER_NAME = "browser";
    public static final String BROWSER_TYPE = "type";
    public static final String FEATURE_RECORDING = PluginBrowser.class.getName() + ".recording";
    private Boolean recording = UtilLog.LOG.isDebugEnabled();
    public static final String FEATURE_WEBDRIVER_TYPE = PluginBrowser.class.getName() + ".webdriver";
    protected String webdriver;
    public static final String FEATURE_WEBDRIVER_FACTORY = PluginBrowser.class.getName() + ".webdriverfactory";
    protected String webdriverfactory;
    public static final String FEATURE_WEBDRIVER_INSTANCE = PluginBrowser.class.getName() + ".webdriverInstance";
    protected WebDriver webdriverInstance;
    public static final String FEATURE_WEBDRIVER_FACTORY_INSTANCE = PluginBrowser.class.getName() + ".webdriverfactoryInstance";
    protected IWebDriverFactory webdriverfactoryInstance;
    public static final String FEATURE_REUSE = PluginBrowser.class.getName() + ".reuse";
    private Boolean reuse = false;

    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public String getWebdriver() {
        return this.webdriver;
    }

    public void setWebdriver(String webdriver) {
        this.webdriver = webdriver;
    }

    public String getWebdriverfactory() {
        return this.webdriverfactory;
    }

    public void setWebdriverfactory(String webdriverfactory) {
        this.webdriverfactory = webdriverfactory;
    }

    public WebDriver getWebdriverInstance() {
        return this.webdriverInstance;
    }

    public void setWebdriverInstance(WebDriver webdriverInstance) {
        this.webdriverInstance = webdriverInstance;
    }

    public IWebDriverFactory getWebdriverfactoryInstance() {
        return this.webdriverfactoryInstance;
    }

    public void setWebdriverfactoryInstance(IWebDriverFactory webdriverfactoryInstance) {
        this.webdriverfactoryInstance = webdriverfactoryInstance;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public PluginBrowser() {
        this.setName(BROWSER_NAME);
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        IFeatureManager fm;
        block9: {
            block8: {
                super.initialize(context);
                fm = SRServices.getFeatureManager();
                fm.set(FEATURE_RECORDING, (Object)this);
                if (this.webdriverfactory == null) {
                    try {
                        fm.setStrict(FEATURE_WEBDRIVER_FACTORY, (Object)this);
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("WebDriver factory is " + this.webdriverfactory);
                        }
                    }
                    catch (FeatureManagerException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block8;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            fm.set(FEATURE_WEBDRIVER_FACTORY_INSTANCE, (Object)this);
            if (this.webdriver == null) {
                try {
                    fm.setStrict(FEATURE_WEBDRIVER_TYPE, (Object)this);
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("WebDriver type is " + this.webdriver);
                    }
                }
                catch (FeatureManagerException e) {
                    if (!UtilLog.LOG.isDebugEnabled()) break block9;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        fm.set(FEATURE_WEBDRIVER_INSTANCE, (Object)this);
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        IListenerManager fac = (IListenerManager)SRServices.get(IListenerManager.class);
        if (this.recording.booleanValue()) {
            fac.add((Object)new PageListener(this.getName()));
        } else {
            fac.remove(this.getName());
        }
        IReuseManager reusables = (IReuseManager)SRServices.get(IReuseManager.class);
        if (this.reuse.booleanValue()) {
            HashMap<String, Object> cfg = new HashMap<String, Object>();
            cfg.put("webdriver", this.webdriver);
            cfg.put("webdriverInstance", this.webdriverInstance);
            cfg.put("webdriverfactory", this.webdriverfactory);
            cfg.put("webdriverfactoryInstance", this.webdriverfactoryInstance);
            IReusable reusable = (IReusable)reusables.get((Object)this.getName());
            if (reusable != null && reusable.canReuse(cfg)) {
                reusable.reset();
                this.save(context, (WebDriver)reusable.getObject());
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Browser (" + this.getName() + ") reused.");
                }
                return ENext.DEEP;
            }
        }
        if (this.webdriverfactory != null) {
            try {
                this.webdriverfactoryInstance = (IWebDriverFactory)Class.forName(this.webdriverfactory).newInstance();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("WebDriver factory of type " + this.webdriverfactoryInstance.getClass() + " will be used.");
                }
            }
            catch (Exception e) {
                throw new PluginException("IWebDriverFactory implementation not found or invalid.", (Throwable)e);
            }
        }
        if (this.webdriverfactoryInstance == null) {
            this.webdriverfactoryInstance = new WebDriverFactoryHtmlUnit();
        }
        if (this.webdriver != null) {
            try {
                this.webdriverInstance = (WebDriver)Class.forName(this.webdriver).newInstance();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("WebDriver of type " + this.webdriverInstance.getClass() + " created.");
                }
            }
            catch (Exception e) {
                throw new PluginException("WebDriver implementation not found or invalid.", (Throwable)e);
            }
        }
        if (this.webdriverInstance == null) {
            this.webdriverInstance = this.webdriverfactoryInstance.create(this.getName() != null ? this.getName() : BROWSER_NAME, context);
        }
        this.save(context, this.webdriverInstance);
        if (this.reuse.booleanValue()) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("WebDriver reuse enabled.");
            }
            reusables.put((Object)this.getName(), (Object)new AbstractReusable<WebDriver>(this.getName(), this.webdriverInstance){

                public boolean canReuse(Map<String, Object> extra) {
                    String localWebdriver = (String)extra.get("webdriver");
                    WebDriver localWebDriverInstance = (WebDriver)extra.get("webdriverInstance");
                    String localWebDriverFactory = (String)extra.get("webdriverfactory");
                    IWebDriverFactory localWebDriverFactoryInstance = (IWebDriverFactory)extra.get("webdriverfactoryInstance");
                    boolean isDriver = PluginBrowser.this.webdriver != null && PluginBrowser.this.webdriver.equalsIgnoreCase(localWebdriver);
                    boolean isDriverInstance = PluginBrowser.this.webdriverInstance != null && PluginBrowser.this.webdriverInstance == localWebDriverInstance;
                    boolean isDriverFactory = PluginBrowser.this.webdriverfactory != null && PluginBrowser.this.webdriverfactory.equalsIgnoreCase(localWebDriverFactory);
                    boolean isDriverFactoryInstance = PluginBrowser.this.webdriverfactoryInstance != null && PluginBrowser.this.webdriverfactoryInstance == localWebDriverFactoryInstance;
                    return isDriverFactory || isDriverFactoryInstance || isDriver || isDriverInstance;
                }

                public void reset() {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("WebDriver recycling '" + this.getName() + "'.");
                    }
                }

                public void release() {
                    PluginBrowser.this.webdriverInstance.quit();
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("WebDriver '" + this.getName() + "' quit.");
                    }
                }
            });
        }
        return ENext.DEEP;
    }

    protected void save(IContext context, final WebDriver driver) {
        String str;
        String string = str = this.getName() != null ? this.getName() : BROWSER_NAME;
        if (this.reuse.booleanValue()) {
            this.saveGlobal(context, str, driver);
        } else {
            this.saveGlobal(context, str, new IDestructable(){

                public Object getObject() {
                    return driver;
                }

                public void destroy() {
                    driver.quit();
                }
            });
        }
        String type = str + "_" + BROWSER_TYPE;
        this.saveGlobal(context, type, driver.getClass().getSimpleName());
    }
}

