/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.assertions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.UtilLog;
import org.specrunner.util.math.Range;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.util.xom.node.CellAdapter;
import org.specrunner.util.xom.node.INodeHolder;
import org.specrunner.util.xom.node.RowAdapter;
import org.specrunner.util.xom.node.TableAdapter;
import org.specrunner.util.xom.node.UtilTable;
import org.specrunner.webdriver.AbstractPluginFindSingle;
import org.specrunner.webdriver.assertions.PluginCompareDate;
import org.specrunner.webdriver.assertions.PluginCompareNode;
import org.specrunner.webdriver.assertions.PluginCompareText;
import org.specrunner.webdriver.assertions.PluginCompareUtils;

public class PluginCompareTable
extends AbstractPluginFindSingle {
    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    @Override
    protected void process(IContext context, IResultSet result, WebDriver client, WebElement element) throws PluginException {
        Node node = context.getNode();
        boolean success = this.compareTable(context, result, client, element, node);
        if (!success) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(node, (IPlugin)this), (Throwable)new PluginException("Tables do not match."), ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
        }
    }

    protected boolean compareTable(IContext context, IResultSet result, WebDriver client, WebElement element, Node node) throws PluginException {
        WebElement tmp;
        boolean success = true;
        Nodes tables = this.getTables(node);
        Node table = UtilNode.getHighest((Nodes[])new Nodes[]{tables});
        if (table == null) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(node, (IPlugin)this), (Throwable)new PluginException("Table to be compared is not specified."));
            return false;
        }
        TableAdapter tableExpected = UtilTable.newTable((Node)table);
        List<WebElement> tablesReceived = this.getTables(element);
        if (tablesReceived.isEmpty()) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(table, (IPlugin)this), (Throwable)new PluginException("Expected table not present in input."));
            return false;
        }
        WebElement tableReceived = tablesReceived.get(0);
        List<WebElement> tableCaptions = this.getCaptions(tableExpected, tableReceived);
        Iterator<WebElement> iteCaptions = tableCaptions.iterator();
        for (CellAdapter expected : tableExpected.getCaptions()) {
            if (!iteCaptions.hasNext()) {
                result.addResult((Status)Failure.INSTANCE, context.newBlock(expected.getNode(), (IPlugin)this), (Throwable)new PluginException("Caption cells missing in received table."));
                success = false;
                continue;
            }
            WebElement received = iteCaptions.next();
            if (this.prepare != null) {
                this.prepare.prepare(this, client, received);
            }
            while (!received.isDisplayed() && iteCaptions.hasNext()) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Ignore table invisible caption:" + received);
                }
                received = iteCaptions.next();
                if (this.prepare == null) continue;
                this.prepare.prepare(this, client, received);
            }
            if (expected.hasAttribute("ignore") || !received.isDisplayed()) continue;
            success &= this.compareTerminal((IPlugin)this, context, result, client, expected, received);
        }
        boolean visible = false;
        while (!visible && iteCaptions.hasNext()) {
            tmp = iteCaptions.next();
            if (this.prepare != null) {
                this.prepare.prepare(this, client, tmp);
            }
            visible = tmp.isDisplayed();
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Check visibility(" + visible + ") for " + tmp);
        }
        if (visible) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(table, (IPlugin)this), (Throwable)new PluginException("Received table has more captions than expected."));
            success = false;
        }
        List<WebElement> tableElements = this.getCells(tableExpected, tableReceived);
        Iterator<WebElement> iteElements = tableElements.iterator();
        for (RowAdapter rowsExpected : tableExpected.getRows()) {
            for (CellAdapter expected : rowsExpected.getCells()) {
                if (!iteElements.hasNext()) {
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(expected.getNode(), (IPlugin)this), (Throwable)new PluginException("Cell missing in received table."));
                    success = false;
                    continue;
                }
                WebElement received = iteElements.next();
                if (this.prepare != null) {
                    this.prepare.prepare(this, client, received);
                }
                while (!received.isDisplayed() && iteElements.hasNext()) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Ignore table invisible element:" + received);
                    }
                    received = iteElements.next();
                    if (this.prepare == null) continue;
                    this.prepare.prepare(this, client, received);
                }
                if (expected.hasAttribute("ignore") || !received.isDisplayed()) continue;
                success &= this.compareTerminal((IPlugin)this, context, result, client, expected, received);
            }
        }
        visible = false;
        while (!visible && iteElements.hasNext()) {
            tmp = iteElements.next();
            if (this.prepare != null) {
                this.prepare.prepare(this, client, tmp);
            }
            visible = tmp.isDisplayed();
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Check visibility(" + visible + ") for " + tmp);
        }
        if (visible) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(table, (IPlugin)this), (Throwable)new PluginException("Received table has more cells than expected."));
            success = false;
        }
        return success;
    }

    protected Nodes getTables(Node expected) {
        return expected.query("descendant-or-self::table");
    }

    protected List<WebElement> getTables(WebElement received) {
        return received.findElements(By.xpath((String)"descendant-or-self::table"));
    }

    protected List<WebElement> getCaptions(TableAdapter tableExpected, WebElement tableReceived) {
        return tableReceived.findElements(By.xpath((String)"child::caption"));
    }

    protected List<WebElement> getCells(TableAdapter tableExpected, WebElement tableReceived) {
        LinkedList<WebElement> result = new LinkedList<WebElement>();
        List rows = tableReceived.findElements(By.xpath((String)"child::tr | child::thead/tr | child::tbody/tr"));
        List rowRanges = Range.getRanges((String)tableExpected.getAttribute("rows"), (String)tableExpected.getAttribute("separator"), (int)0, (int)rows.size());
        List colRanges = Range.getRanges((String)tableExpected.getAttribute("cols"), (String)tableExpected.getAttribute("separator"), (int)0, (int)Integer.MAX_VALUE);
        int sourceRows = 0;
        int tmpRowRange = 0;
        for (int i = 0; i < rows.size() && tmpRowRange < rowRanges.size(); ++i) {
            Range rowRange = (Range)rowRanges.get(tmpRowRange);
            boolean skipRange = false;
            while (rowRange.between(i) && i < rows.size()) {
                skipRange = true;
                List cols = ((WebElement)rows.get(i)).findElements(By.xpath((String)"child::th | child::td"));
                int sourceCells = 0;
                int tmpColRange = 0;
                for (int j = 0; j < cols.size() && tmpColRange < colRanges.size(); ++tmpColRange, ++j) {
                    Range colRange = (Range)colRanges.get(tmpColRange);
                    while (colRange.between(j) && j < cols.size()) {
                        if (UtilLog.LOG.isDebugEnabled()) {
                            CellAdapter cell;
                            cell.setAttribute("title", (cell = ((RowAdapter)tableExpected.getRows().get(sourceRows)).getCell(sourceCells)).hasAttribute("title") ? cell.getAttribute("title") + " (" + i + "," + j + ")" : " (" + i + "," + j + ")");
                        }
                        result.add((WebElement)cols.get(j));
                        ++sourceCells;
                        ++j;
                    }
                }
                ++sourceRows;
                ++i;
            }
            if (!skipRange) continue;
            ++tmpRowRange;
        }
        return result;
    }

    protected boolean compareTerminal(IPlugin plugin, IContext context, IResultSet result, WebDriver client, CellAdapter expected, WebElement received) throws PluginException {
        if (PluginCompareTable.isTable((INodeHolder)expected)) {
            return this.compareTable(context, result, client, received, expected.getNode());
        }
        if (PluginCompareDate.isDate((INodeHolder)expected)) {
            PluginCompareDate compare = (PluginCompareDate)UtilPlugin.create((IContext)context, PluginCompareDate.class, (Element)((Element)expected.getNode()), (boolean)true);
            Object tmp = this.getValue(compare.getValue() != null ? compare.getValue() : expected.getValue(context), compare.isEval(), context);
            String exp = String.valueOf(tmp);
            if (!expected.getValue(context).equals(exp)) {
                expected.append("{" + exp + "}");
            }
            String rec = received.getText();
            return PluginCompareUtils.compareDate(compare, exp, rec, context.newBlock(expected.getNode(), plugin), context, result, null);
        }
        if (PluginCompareNode.isNode((INodeHolder)expected)) {
            PluginCompareNode compare = (PluginCompareNode)UtilPlugin.create((IContext)context, PluginCompareNode.class, (Element)((Element)expected.getNode()), (boolean)true);
            return PluginCompareUtils.compareNode(compare, (Element)expected.getNode(), received, context.newBlock(expected.getNode(), plugin), context, result);
        }
        PluginCompareText compare = (PluginCompareText)UtilPlugin.create((IContext)context, PluginCompareText.class, (Element)((Element)expected.getNode()), (boolean)true);
        Object tmp = this.getValue(compare.getValue() != null ? compare.getValue() : expected.getValue(context), compare.isEval(), context);
        String exp = String.valueOf(tmp);
        if (!expected.getValue(context).equals(exp)) {
            expected.append("{" + exp + "}");
        }
        String rec = received.getText();
        return PluginCompareUtils.compare(compare.getNormalized(exp), compare.getNormalized(rec), context.newBlock(expected.getNode(), plugin), context, result, null);
    }

    public static boolean isTable(INodeHolder holder) {
        return holder.attributeEquals("type", "table");
    }
}

