/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.result;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.specrunner.result.IWritable;
import org.specrunner.result.ResultException;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IHtmlUnitDriver;

public class WritableWebDriver
implements IWritable {
    private final Map<String, Object> information;
    private File tmpDump;
    private File tmpSource;

    public WritableWebDriver(WebDriver driver) {
        this(null, driver);
    }

    public WritableWebDriver(Map<String, Object> information, WebDriver driver) {
        block7: {
            this.information = information;
            try {
                if (driver instanceof IHtmlUnitDriver) {
                    this.dumpScreenShot((IHtmlUnitDriver)driver);
                } else if (driver instanceof TakesScreenshot) {
                    this.dumpScreenshot(driver, (TakesScreenshot)driver);
                } else if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Driver type is " + (driver != null ? driver.getClass() : "null"));
                }
            }
            catch (IOException e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block7;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean hasInformation() {
        return this.information != null && !this.information.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpScreenshot(WebDriver source, TakesScreenshot driver) throws IOException {
        Point p;
        Dimension d;
        WebDriver.Window window;
        block12: {
            window = source.manage().window();
            d = null;
            p = null;
            try {
                d = window.getSize();
                p = window.getPosition();
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isInfoEnabled()) break block12;
                UtilLog.LOG.info("Could not get size and position.");
            }
        }
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            this.tmpDump = File.createTempFile("srunnerw", this.getExtension(scrFile));
            this.tmpDump.delete();
            FileUtils.copyFile((File)scrFile, (File)this.tmpDump);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Saved page screen to temporary file " + this.tmpDump);
            }
            this.tmpSource = File.createTempFile("srunnerw", ".html");
            this.tmpSource.delete();
            FileUtils.writeStringToFile((File)this.tmpSource, (String)source.getPageSource());
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Saved page source to temporary file " + this.tmpSource);
            }
        }
        catch (WebDriverException e) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Could not dump screenshot.");
            }
        }
        finally {
            if (d != null && p != null) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Restore size and location.");
                }
                window.setPosition(p);
                window.setSize(d);
            }
        }
    }

    protected String getExtension(File scrFile) {
        String name = scrFile.getName();
        name = name.substring(name.lastIndexOf(46), name.length());
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpScreenShot(IHtmlUnitDriver driver) throws IOException {
        WebWindow window;
        WebClient wb = driver.getWebClient();
        if (wb != null && (window = wb.getCurrentWindow()) != null) {
            Page page = window.getEnclosedPage();
            if (page instanceof HtmlPage) {
                Page page2 = page;
                synchronized (page2) {
                    this.tmpDump = File.createTempFile("srunnerw", ".html");
                    this.tmpDump.delete();
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("Saving page to temporary file " + this.tmpDump);
                    }
                    OutputStreamWriter fout = null;
                    try {
                        HtmlPage html = (HtmlPage)page;
                        html.save(this.tmpDump);
                    }
                    catch (IOException e) {
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug("Page information could not be saved.");
                            UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                    finally {
                        block21: {
                            try {
                                if (fout != null) {
                                    fout.close();
                                }
                            }
                            catch (IOException e) {
                                if (!UtilLog.LOG.isTraceEnabled()) break block21;
                                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Page type is " + (page != null ? page.getClass() : "null"));
            }
        }
    }

    public Map<String, Object> getInformation() {
        return this.information;
    }

    public Map<String, String> writeTo(String target) throws ResultException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.tmpDump != null) {
            this.dump(this.tmpDump, target, map, "screen");
        }
        if (this.tmpSource != null) {
            this.dump(this.tmpSource, target, map, "source");
        }
        return map;
    }

    protected void dump(File from, String target, Map<String, String> map, String label) throws ResultException {
        File to = new File(target + this.getExtension(from));
        try {
            this.move(from, to);
        }
        catch (IOException e) {
            throw new ResultException((Throwable)e);
        }
        String name = from.getName();
        try {
            File dir = new File(from.getParentFile(), name.substring(0, name.lastIndexOf(46)));
            if (dir.exists()) {
                this.move(dir, new File(to.getParentFile(), dir.getName()));
            }
        }
        catch (IOException e) {
            throw new ResultException((Throwable)e);
        }
        map.put(label, to.toURI().toString());
    }

    protected void move(File from, File to) throws IOException, ResultException {
        if (to.exists() && !to.delete()) {
            throw new ResultException("Could not remove resources '" + to + "'.");
        }
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("Moving " + from + " to " + to + ".");
        }
        if (from.isDirectory()) {
            FileUtils.moveDirectory((File)from, (File)to);
        } else {
            FileUtils.moveFile((File)from, (File)to);
        }
    }
}

