/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.actions;

import java.net.MalformedURLException;
import java.net.URL;
import nu.xom.Node;
import org.openqa.selenium.WebDriver;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.AbstractPluginUrlAware;
import org.specrunner.webdriver.actions.PluginStartIn;

public class PluginOpen
extends AbstractPluginUrlAware {
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    protected void doEnd(IContext context, IResultSet result, WebDriver client) throws PluginException {
        Node node = context.getNode();
        String u = this.getUrl() != null ? this.getUrl() : node.getValue();
        String tmp = this.getBrowserName();
        if (!u.startsWith("http") && !u.startsWith("file")) {
            String target;
            String baseUrl = (String)context.getByName(PluginStartIn.getBaseForBrowser(tmp));
            if (baseUrl == null) {
                throw new PluginException("Could not find base url for browser '" + tmp + "'.");
            }
            try {
                URL base = new URL(baseUrl);
                target = new URL(base, u).toString();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Relative url resolved from '" + u + "' to '" + target + "'.");
                }
            }
            catch (MalformedURLException e) {
                throw new PluginException("Could not resolve '" + baseUrl + "' with " + u + ".", (Throwable)e);
            }
            u = target;
        }
        PluginException error = null;
        try {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Openning '" + u + "' on browser named '" + tmp + "'.");
            }
            client.get(u);
        }
        catch (Exception e) {
            error = new PluginException((Throwable)e);
        }
        if (error != null && !this.isIgnorable(error)) {
            throw error;
        }
        result.addResult((Status)Success.INSTANCE, context.newBlock(node, (IPlugin)this));
    }

    protected boolean isIgnorable(PluginException error) {
        return false;
    }
}

