/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.actions;

import nu.xom.Node;
import org.openqa.selenium.WebDriver;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritableFactoryManager;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;
import org.specrunner.util.expression.UtilExpression;
import org.specrunner.util.string.IStringProvider;
import org.specrunner.webdriver.AbstractPluginUrlAware;

public class PluginStartIn
extends AbstractPluginUrlAware {
    public static final String START_IN = "startIn";
    private String provider;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    protected void doEnd(IContext context, IResultSet result, WebDriver client) throws PluginException {
        Node node = context.getNode();
        String tmp = this.getBrowserName();
        String u = null;
        if (this.provider == null) {
            u = this.getUrl() != null ? this.getUrl() : node.getValue();
            u = String.valueOf(UtilExpression.evaluate((String)u, (IContext)context, (boolean)true));
        } else {
            try {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Trying to recover base URL from provider '" + this.provider + "'.");
                }
                u = this.getBaseFromProvider(context);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Base url provided is '" + u + "'.");
                }
            }
            catch (Exception e) {
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                }
                result.addResult((Status)Failure.INSTANCE, context.newBlock(node, (IPlugin)this), (Throwable)e, ((IWritableFactoryManager)SRServices.get(IWritableFactoryManager.class)).get(WebDriver.class).newWritable((Object)client));
                return;
            }
        }
        context.saveGlobal(PluginStartIn.getBaseForBrowser(tmp), (Object)u);
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Browser named '" + tmp + "' base url set to '" + u + "'.");
        }
        result.addResult((Status)Success.INSTANCE, context.newBlock(node, (IPlugin)this));
    }

    protected String getBaseFromProvider(IContext context) throws Exception {
        return ((IStringProvider)Class.forName(this.provider).newInstance()).newString(context);
    }

    public static String getBaseForBrowser(String browserName) {
        return browserName + "_" + START_IN;
    }
}

