/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.lang.reflect.Constructor;
import org.apache.http.client.CredentialsProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.specrunner.SRServices;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.IParameterDecorator;
import org.specrunner.parameters.core.ParameterDecoratorImpl;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.IHtmlUnitDriver;
import org.specrunner.webdriver.impl.htmlunit.IWebConnection;
import org.specrunner.webdriver.impl.htmlunit.OptimizedCssErrorHandler;
import org.specrunner.webdriver.impl.htmlunit.OptimizedIncorrectnessListener;
import org.w3c.css.sac.ErrorHandler;

public class HtmlUnitDriverLocal
extends HtmlUnitDriver
implements IHtmlUnitDriver {
    private IParameterDecorator parameters;
    private String name;
    public static final String FEATURE_HOST = HtmlUnitDriverLocal.class.getName() + ".host";
    private String host;
    public static final String FEATURE_PORT = HtmlUnitDriverLocal.class.getName() + ".port";
    private Integer port;
    public static final String FEATURE_USERNAME = HtmlUnitDriverLocal.class.getName() + ".username";
    private String username;
    public static final String FEATURE_PASSWORD = HtmlUnitDriverLocal.class.getName() + ".password";
    private String password;
    public static final String FEATURE_HTTPTIMEOUT = HtmlUnitDriverLocal.class.getName() + ".httptimeout";
    private Integer httptimeout = 0;
    public static final String FEATURE_CONNECTION = HtmlUnitDriverLocal.class.getName() + ".connection";
    private String connection;
    private Class<? extends IWebConnection> connectionType;
    public static final String FEATURE_CACHE = HtmlUnitDriverLocal.class.getName() + ".cache";
    private String cache;
    private Cache cacheInstance;
    public static final String FEATURE_CACHED = HtmlUnitDriverLocal.class.getName() + ".cached";
    private Boolean cached = true;

    public HtmlUnitDriverLocal() {
    }

    public HtmlUnitDriverLocal(boolean enableJavascript) {
        super(enableJavascript);
    }

    public HtmlUnitDriverLocal(BrowserVersion version) {
        super(version);
    }

    public HtmlUnitDriverLocal(Capabilities capabilities) {
        super(capabilities);
    }

    public IParameterDecorator getParameters() {
        return this.parameters;
    }

    public void setParameters(IParameterDecorator parameters) {
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getHttptimeout() {
        return this.httptimeout;
    }

    public void setHttptimeout(Integer httptimeout) {
        this.httptimeout = httptimeout;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public Boolean getCached() {
        return this.cached;
    }

    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public WebClient getWebClient() {
        return super.getWebClient();
    }

    protected WebClient modifyWebClient(WebClient client) {
        this.parameters = new ParameterDecoratorImpl();
        this.parameters.setDecorated((Object)this);
        return client;
    }

    public void setHeader(String name, String value) {
        this.getWebClient().addRequestHeader(name, value);
    }

    public void initialize() {
        this.setFeatures();
        WebClient client = this.getWebClient();
        this.setBasic(client);
        this.setConnection(client);
        this.setProxy(client);
        this.setCredentials(client);
        this.setCache(client);
        this.setTime(client);
    }

    protected void setFeatures() {
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.host == null) {
            fm.set(FEATURE_HOST, (Object)this);
        }
        if (this.port == null) {
            fm.set(FEATURE_PORT, (Object)this);
        }
        if (this.username == null) {
            fm.set(FEATURE_USERNAME, (Object)this);
        }
        if (this.password == null) {
            fm.set(FEATURE_PASSWORD, (Object)this);
        }
        fm.set(FEATURE_HTTPTIMEOUT, (Object)this);
        if (this.connection == null) {
            fm.set(FEATURE_CONNECTION, (Object)this);
        }
        if (this.cache == null) {
            fm.set(FEATURE_CACHE, (Object)this);
        }
        if (this.cached == null) {
            fm.set(FEATURE_CACHED, (Object)this);
        }
    }

    protected void setBasic(WebClient client) {
        client.getOptions().setUseInsecureSSL(true);
        client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        client.setCssErrorHandler((ErrorHandler)new OptimizedCssErrorHandler());
        client.setIncorrectnessListener((IncorrectnessListener)new OptimizedIncorrectnessListener());
    }

    protected void setConnection(WebClient client) {
        if (this.connection != null) {
            try {
                this.connectionType = Class.forName(this.connection);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Connection class '" + this.connection + "' not found, or is not a subtype of " + WebConnection.class.getName() + ".", e);
            }
        }
        if (this.connectionType != null) {
            WebConnection connectionInstance = null;
            try {
                Constructor<? extends IWebConnection> constr = this.connectionType.getConstructor(WebClient.class);
                connectionInstance = constr.newInstance(client);
            }
            catch (Exception e) {
                try {
                    connectionInstance = this.connectionType.newInstance();
                }
                catch (Exception e1) {
                    throw new RuntimeException("Constructor with WebClient argument or empty not found for '" + this.connectionType + "'.", e);
                }
            }
            client.setWebConnection(connectionInstance);
        }
    }

    protected void setProxy(WebClient client) {
        if (this.host != null && this.port != null) {
            ProxyConfig config = new ProxyConfig(this.host, this.port.intValue());
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Browser named '" + this.getName() + "' proxy '" + this.host + ":" + this.port + "'.");
            }
            client.getOptions().setProxyConfig(config);
        }
    }

    protected void setCredentials(WebClient client) {
        if (this.username != null && this.password != null) {
            DefaultCredentialsProvider provider = new DefaultCredentialsProvider();
            provider.addCredentials(this.username, this.password);
            client.setCredentialsProvider((CredentialsProvider)provider);
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Browser named '" + this.getName() + "' credentials '" + this.username + "|" + this.password + "'.");
            }
        }
    }

    protected void setCache(WebClient client) {
        if (this.cache != null) {
            try {
                Class<?> cacheType = Class.forName(this.cache);
                this.cacheInstance = (Cache)cacheType.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cache class '" + this.cache + "' not found, or is not a subtype of " + Cache.class.getName() + ".", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Cache class '" + this.cache + "' instance could not be created.", e);
            }
        }
        if (this.cached.booleanValue() || this.cacheInstance != null) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Browser named '" + this.getName() + "' cached.");
            }
            Cache cacheLocal = null;
            if (this.cacheInstance == null) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Using default cache.");
                }
                cacheLocal = new Cache(){

                    protected boolean isCacheableContent(WebResponse response) {
                        boolean dynamic;
                        String type = response.getContentType();
                        boolean bl = dynamic = ("".equals(type) || "text/html".equals(type)) && !super.isCacheableContent(response);
                        if (UtilLog.LOG.isInfoEnabled()) {
                            String url = response.getWebRequest().getUrl().toString();
                            UtilLog.LOG.info("Dynamic '" + type + "' = " + dynamic + ", loaded in " + response.getLoadTime() + "mls, URL: " + url + ".");
                        }
                        return !dynamic;
                    }
                };
            } else {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Using customized cache '" + this.cacheInstance.getClass() + "'.");
                }
                cacheLocal = this.cacheInstance;
            }
            client.setCache(cacheLocal);
        } else if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Browser named '" + this.getName() + "' not cached.");
        }
    }

    protected void setTime(WebClient client) {
        client.getOptions().setTimeout(this.httptimeout.intValue());
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Browser named '" + this.getName() + "' bound to '" + client + "'.");
        }
    }
}

