/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.control.eff.Eff;
import org.specs2.control.eff.Eff$;
import org.specs2.control.eff.EffectsCons;
import org.specs2.control.eff.ErrorEffect$;
import org.specs2.control.eff.NoEffect;
import org.specs2.control.package$;
import org.specs2.control.package$Actions$;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FilePath;
import org.specs2.io.FileSystem;
import org.specs2.io.FileSystem$;
import org.specs2.io.FileSystem$$anonfun$copyDir$1$;
import org.specs2.io.FileSystem$$anonfun$copyDir$2$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scalaz.;
import scalaz.Bind;
import scalaz.Catchable;
import scalaz.Monad;
import scalaz.Name;
import scalaz.Unapply$;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.std.list$;
import scalaz.stream.Process;
import scalaz.stream.Process$;
import scalaz.stream.io$;
import scalaz.stream.text$;

public abstract class FileSystem$class {
    public static Eff deleteFile(FileSystem $this, FilePath filePath) {
        return package$Actions$.MODULE$.safe(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.filePath$1.toFile().delete();
            }
            {
                this.filePath$1 = filePath$1;
            }
        });
    }

    public static Eff writeFile(FileSystem $this, FilePath filePath, String content) {
        return package$Actions$.MODULE$.fromTask($this.writeFileTask(filePath, content));
    }

    public static Eff updateFileContent(FileSystem $this, FilePath filePath, Function1 update) {
        return $this.readFile(filePath).flatMap(new Serializable($this, filePath, update){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final FilePath filePath$2;
            private final Function1 update$1;

            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply(String s) {
                return this.$outer.writeFile(this.filePath$2, (String)this.update$1.apply((Object)s));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filePath$2 = filePath$2;
                this.update$1 = update$1;
            }
        });
    }

    public static Eff replaceInFile(FileSystem $this, FilePath filePath, String source, String target) {
        return $this.updateFileContent(filePath, (Function1<String, String>)new Serializable($this, source, target){
            public static final long serialVersionUID = 0L;
            private final String source$1;
            private final String target$1;

            public final String apply(String x$1) {
                return x$1.replace(this.source$1, this.target$1);
            }
            {
                this.source$1 = source$1;
                this.target$1 = target$1;
            }
        });
    }

    public static Task writeFileTask(FileSystem $this, FilePath filePath, String content) {
        return (Task)scalaz.syntax.package$.MODULE$.all().ToBindOps(package$.MODULE$.actionToTask($this.mkdirs(filePath)).toConsoleTask(), (Bind)Task$.MODULE$.taskInstance()).$greater$greater((Function0)new Serializable($this, filePath, content){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$3;
            private final String content$1;

            public final Task<BoxedUnit> apply() {
                return (Task)Process.ProcessSyntax$.MODULE$.to$extension(Process$.MODULE$.ProcessSyntax(Process.Process0Syntax$.MODULE$.toSource$extension(Process$.MODULE$.Process0Syntax(Process$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.content$1})))).pipe(text$.MODULE$.utf8Encode())), io$.MODULE$.fileChunkW(this.filePath$3.path(), io$.MODULE$.fileChunkW$default$2(), io$.MODULE$.fileChunkW$default$3())).run((Monad)Task$.MODULE$.taskInstance(), (Catchable)Task$.MODULE$.taskInstance());
            }
            {
                this.filePath$3 = filePath$3;
                this.content$1 = content$1;
            }
        });
    }

    public static Eff withEphemeralFile(FileSystem $this, FilePath path2, Eff action) {
        return ErrorEffect$.MODULE$.ErrorEffectOps(action).andFinally((Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOps($this.deleteFile(path2), Eff$.MODULE$.EffMonad()).void(), package$.MODULE$.ErrorMember());
    }

    public static Eff mkdirs(FileSystem $this, DirectoryPath path2) {
        return (Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOps(package$Actions$.MODULE$.safe(new Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath path$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.path$1.toFile().mkdirs();
            }
            {
                this.path$1 = path$1;
            }
        }), Eff$.MODULE$.EffMonad()).void();
    }

    public static Eff mkdirs(FileSystem $this, FilePath path2) {
        return $this.mkdirs(path2.dir());
    }

    public static Eff unjar(FileSystem $this, URL jarUrl, DirectoryPath dest, String regexFilter) {
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));
        return package$Actions$.MODULE$.safe(new Serializable($this, regex, zis, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final Pattern regex$1;
            private final ZipInputStream zis$1;
            private final DirectoryPath dest$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    FileSystem$class.extractEntry$1(this.$outer, this.zis$1.getNextEntry(), this.regex$1, this.zis$1, this.dest$1);
                    return;
                }
                finally {
                    this.zis$1.close();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.regex$1 = regex$1;
                this.zis$1 = zis$1;
                this.dest$1 = dest$1;
            }
        });
    }

    private static void copy(FileSystem $this, InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        FileSystem$class.readData$1($this, input.read(data, 0, 2048), input, output, data);
    }

    public static Eff copyDir(FileSystem $this, DirectoryPath src, DirectoryPath dest) {
        return (Eff)scalaz.syntax.package$.MODULE$.all().ToBindOps(scalaz.syntax.package$.MODULE$.all().ToBindOps($this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater((Function0)new Serializable($this, src, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final DirectoryPath src$1;
            public final DirectoryPath dest$2;

            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply() {
                return this.$outer.listDirectFilePaths(this.src$1).flatMap(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.copyDir.1 $outer;

                    public final Eff<EffectsCons<?, EffectsCons<?, EffectsCons<?, EffectsCons<?, NoEffect>>>>, BoxedUnit> apply(IndexedSeq<FilePath> files) {
                        return (Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOpsUnapply(scalaz.syntax.package$.MODULE$.all().ToTraverseOps(files.toList().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileSystem$$anonfun$copyDir$1$.anonfun.apply.2 $outer;

                            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply(FilePath filePath) {
                                return this.$outer.org$specs2$io$FileSystem$$anonfun$$anonfun$$$outer().org$specs2$io$FileSystem$$anonfun$$$outer().copyFile(this.$outer.org$specs2$io$FileSystem$$anonfun$$anonfun$$$outer().dest$2, filePath);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, List$.MODULE$.canBuildFrom()), list$.MODULE$.listInstance()).sequenceU(Unapply$.MODULE$.unapplyMA(Eff$.MODULE$.EffMonad())), Unapply$.MODULE$.unapplyMAB2(Eff$.MODULE$.EffMonad())).void();
                    }

                    public /* synthetic */ FileSystem$.anonfun.copyDir.1 org$specs2$io$FileSystem$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.src$1 = src$1;
                this.dest$2 = dest$2;
            }
        }), Eff$.MODULE$.EffMonad()).$greater$greater((Function0)new Serializable($this, src, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final DirectoryPath src$1;
            public final DirectoryPath dest$2;

            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply() {
                return this.$outer.listDirectDirectoryPaths(this.src$1).flatMap(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.copyDir.2 $outer;

                    public final Eff<EffectsCons<?, EffectsCons<?, EffectsCons<?, EffectsCons<?, NoEffect>>>>, BoxedUnit> apply(IndexedSeq<DirectoryPath> directories) {
                        return (Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOpsUnapply(scalaz.syntax.package$.MODULE$.all().ToTraverseOps(directories.toList().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileSystem$$anonfun$copyDir$2$.anonfun.apply.4 $outer;

                            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply(DirectoryPath dir2) {
                                return this.$outer.org$specs2$io$FileSystem$$anonfun$$anonfun$$$outer().org$specs2$io$FileSystem$$anonfun$$$outer().copyDir(dir2, this.$outer.org$specs2$io$FileSystem$$anonfun$$anonfun$$$outer().dest$2.$div(dir2.name()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, List$.MODULE$.canBuildFrom()), list$.MODULE$.listInstance()).sequenceU(Unapply$.MODULE$.unapplyMA(Eff$.MODULE$.EffMonad())), Unapply$.MODULE$.unapplyMAB2(Eff$.MODULE$.EffMonad())).void();
                    }

                    public /* synthetic */ FileSystem$.anonfun.copyDir.2 org$specs2$io$FileSystem$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.src$1 = src$1;
                this.dest$2 = dest$2;
            }
        });
    }

    public static Eff copyFile(FileSystem $this, DirectoryPath dest, FilePath filePath) {
        return (Eff)scalaz.syntax.package$.MODULE$.all().ToBindOps($this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater((Function0)new Serializable($this, dest, filePath){
            public static final long serialVersionUID = 0L;
            public final DirectoryPath dest$3;
            public final FilePath filePath$4;

            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply() {
                return (Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOps(package$Actions$.MODULE$.safe(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.copyFile.1 $outer;

                    public final Path apply() {
                        return Files.copy(Paths.get(this.$outer.filePath$4.path(), new String[0]), Paths.get(this.$outer.dest$3.path(), new String[0]).resolve(Paths.get(this.$outer.filePath$4.name().name(), new String[0])), StandardCopyOption.REPLACE_EXISTING);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), Eff$.MODULE$.EffMonad()).void();
            }
            {
                this.dest$3 = dest$3;
                this.filePath$4 = filePath$4;
            }
        });
    }

    public static Eff createFile(FileSystem $this, FilePath filePath) {
        return (Eff)scalaz.syntax.package$.MODULE$.all().ToBindOps($this.mkdirs(filePath.dir()), Eff$.MODULE$.EffMonad()).$greater$greater((Function0)new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            public final FilePath filePath$5;

            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, Object> apply() {
                return package$Actions$.MODULE$.safe(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.createFile.1 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.filePath$5.toFile().createNewFile();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.filePath$5 = filePath$5;
            }
        });
    }

    public static Eff delete(FileSystem $this, FilePath file2) {
        return (Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOps(package$Actions$.MODULE$.safe(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final FilePath file$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$1.toFile().delete();
            }
            {
                this.file$1 = file$1;
            }
        }), Eff$.MODULE$.EffMonad()).void();
    }

    public static Eff delete(FileSystem $this, DirectoryPath dir2) {
        return (Eff)scalaz.syntax.package$.MODULE$.all().ToBindOpsUnapply($this.listFilePaths(dir2).flatMap(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;

            public final Eff<EffectsCons<?, EffectsCons<?, EffectsCons<?, EffectsCons<?, NoEffect>>>>, BoxedUnit> apply(IndexedSeq<FilePath> x$2) {
                return (Eff)scalaz.syntax.package$.MODULE$.all().ToFunctorOpsUnapply(scalaz.syntax.package$.MODULE$.all().ToTraverseOps((Object)((TraversableOnce)x$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.delete.2 $outer;

                    public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply(FilePath file2) {
                        return this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer().delete(file2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toList(), list$.MODULE$.listInstance()).sequenceU(Unapply$.MODULE$.unapplyMA(Eff$.MODULE$.EffMonad())), Unapply$.MODULE$.unapplyMAB2(Eff$.MODULE$.EffMonad())).void();
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), Unapply$.MODULE$.unapplyMAB2(Eff$.MODULE$.EffMonad())).$greater$greater((Function0)new Serializable($this, dir2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final DirectoryPath dir$1;

            public final Eff<EffectsCons<.bslash.div, EffectsCons<Object, EffectsCons<Object, EffectsCons<Name, NoEffect>>>>, BoxedUnit> apply() {
                return this.$outer.delete(this.dir$1.toFilePath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void extractEntry$1(FileSystem $this, ZipEntry entry, Pattern regex$1, ZipInputStream zis$1, DirectoryPath dest$1) {
        while (true) {
            if (entry == null) {
                return;
            }
            Matcher matcher = regex$1.matcher(entry.getName());
            if (matcher.matches()) {
                String target = matcher.replaceFirst(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Matcher.quoteReplacement(dest$1.path())})));
                if (!entry.isDirectory()) {
                    new File(target).getParentFile().mkdirs();
                    new File(target).createNewFile();
                    FileOutputStream fos = new FileOutputStream(target);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    try {
                        FileSystem$class.copy($this, zis$1, dest);
                        dest.flush();
                    }
                    catch (Throwable throwable) {
                        void var9_8;
                        var9_8.close();
                        throw throwable;
                    }
                    dest.close();
                }
            }
            entry = zis$1.getNextEntry();
        }
    }

    private static final void readData$1(FileSystem $this, int count2, InputStream input$1, OutputStream output$1, byte[] data$1) {
        while (count2 != -1) {
            output$1.write(data$1, 0, count2);
            output$1.flush();
            count2 = input$1.read(data$1, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

