/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.concurrent;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.specs2.concurrent.ExecutorServices;
import org.specs2.concurrent.Scheduler;
import org.specs2.concurrent.Schedulers$;
import org.specs2.control.NamedThreadFactory;
import org.specs2.control.NamedThreadFactory$;
import org.specs2.control.eff.ConsoleEffect$;
import org.specs2.control.eff.Evaluated;
import org.specs2.control.eff.Member$;
import org.specs2.control.eff.MemberIn$;
import org.specs2.control.eff.Memoized$;
import org.specs2.main.Arguments;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

public final class ExecutorServices$
implements scala.Serializable {
    public static ExecutorServices$ MODULE$;
    private int threadsNb;
    private int specs2ThreadsNb;
    private volatile byte bitmap$0;

    static {
        new ExecutorServices$();
    }

    private int threadsNb$lzycompute() {
        ExecutorServices$ executorServices$ = this;
        synchronized (executorServices$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.threadsNb = package$.MODULE$.max(Runtime.getRuntime().availableProcessors(), 4);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadsNb;
    }

    public int threadsNb() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadsNb$lzycompute() : this.threadsNb;
    }

    private int specs2ThreadsNb$lzycompute() {
        ExecutorServices$ executorServices$ = this;
        synchronized (executorServices$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.specs2ThreadsNb = package$.MODULE$.max(Runtime.getRuntime().availableProcessors(), 4);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.specs2ThreadsNb;
    }

    public int specs2ThreadsNb() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.specs2ThreadsNb$lzycompute() : this.specs2ThreadsNb;
    }

    public ExecutorServices create(Arguments arguments2, Function1<String, BoxedUnit> systemLogger, Option<String> tag) {
        return this.createExecutorServices(arguments2, systemLogger, tag, false);
    }

    public Option<String> create$default$3() {
        return None$.MODULE$;
    }

    public ExecutorServices createSpecs2(Arguments arguments2, Function1<String, BoxedUnit> systemLogger, Option<String> tag) {
        return this.createExecutorServices(arguments2, systemLogger, tag, true);
    }

    public Option<String> createSpecs2$default$3() {
        return None$.MODULE$;
    }

    private ExecutorServices createExecutorServices(Arguments arguments2, Function1<String, BoxedUnit> systemLogger, Option<String> tag, boolean isSpecs2) {
        LazyRef executorService$lzy = new LazyRef();
        LazyRef scheduledExecutorService$lzy = new LazyRef();
        LazyRef executionContext$lzy = new LazyRef();
        String threadFactoryName = isSpecs2 ? "specs2" + tag.map((Function1 & Serializable & scala.Serializable)x$2 -> "-" + x$2).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") : "specs2.user" + tag.map((Function1 & Serializable & scala.Serializable)x$3 -> "-" + x$3).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new ExecutorServices(Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.executorService$1(arguments2, isSpecs2, threadFactoryName, executorService$lzy)), Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.executionContext$1(arguments2, systemLogger, isSpecs2, threadFactoryName, executorService$lzy, executionContext$lzy)), Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.scheduledExecutorService$1(arguments2, threadFactoryName, scheduledExecutorService$lzy)), Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Schedulers$.MODULE$.schedulerFromScheduledExecutorService(this.scheduledExecutorService$1(arguments2, threadFactoryName, scheduledExecutorService$lzy))), Memoized$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                this.executorService$1(arguments2, isSpecs2, threadFactoryName, executorService$lzy).shutdown();
            }
            finally {
                this.scheduledExecutorService$1(arguments2, threadFactoryName, scheduledExecutorService$lzy).shutdown();
            }
        }));
    }

    public ExecutorServices fromExecutionContext(ExecutionContext ec) {
        return new ExecutorServices(Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.fixedExecutor(1, "unused")), Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ec), Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.scheduledExecutor(1, "unused")), Memoized$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Schedulers$.MODULE$.default()), Memoized$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}));
    }

    public ExecutorServices fromGlobalExecutionContext() {
        return this.fromExecutionContext((ExecutionContext)ExecutionContext$.MODULE$.global());
    }

    public ExecutionContextExecutorService createExecutionContext(ExecutorService executorService, boolean verbose, Function1<String, BoxedUnit> systemLogger) {
        return ExecutionContext$.MODULE$.fromExecutorService(executorService, (Function1 & Serializable & scala.Serializable)t -> {
            ConsoleEffect$.MODULE$.runConsoleToPrinter((Function1<String, BoxedUnit>)systemLogger, ConsoleEffect$.MODULE$.logThrowable(t, verbose, MemberIn$.MODULE$.MemberIn1()), Member$.MODULE$.Member1());
            return BoxedUnit.UNIT;
        });
    }

    public ExecutorService fixedExecutor(int threadsNb, String name) {
        return Executors.newFixedThreadPool(threadsNb, new NamedThreadFactory(name, NamedThreadFactory$.MODULE$.apply$default$2(), NamedThreadFactory$.MODULE$.apply$default$3()));
    }

    public ScheduledExecutorService scheduledExecutor(int scheduledThreadsNb, String name) {
        return Executors.newScheduledThreadPool(scheduledThreadsNb, new NamedThreadFactory("specs2.scheduled." + name, NamedThreadFactory$.MODULE$.apply$default$2(), NamedThreadFactory$.MODULE$.apply$default$3()));
    }

    public ExecutorServices apply(Evaluated<ExecutorService> executorServiceEval, Evaluated<ExecutionContext> executionContextEval, Evaluated<ScheduledExecutorService> scheduledExecutorServiceEval, Evaluated<Scheduler> schedulerEval, Evaluated<BoxedUnit> shutdown) {
        return new ExecutorServices(executorServiceEval, executionContextEval, scheduledExecutorServiceEval, schedulerEval, shutdown);
    }

    public Option<Tuple5<Evaluated<ExecutorService>, Evaluated<ExecutionContext>, Evaluated<ScheduledExecutorService>, Evaluated<Scheduler>, Evaluated<BoxedUnit>>> unapply(ExecutorServices x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.executorServiceEval(), x$0.executionContextEval(), x$0.scheduledExecutorServiceEval(), x$0.schedulerEval(), x$0.shutdown()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final /* synthetic */ ExecutorService executorService$lzycompute$1(Arguments arguments$1, boolean isSpecs2$1, String threadFactoryName$1, LazyRef executorService$lzy$1) {
        ExecutorService executorService;
        LazyRef lazyRef = executorService$lzy$1;
        synchronized (lazyRef) {
            executorService = executorService$lzy$1.initialized() ? (ExecutorService)executorService$lzy$1.value() : (ExecutorService)executorService$lzy$1.initialize((Object)(isSpecs2$1 ? this.fixedExecutor(arguments$1.specs2ThreadsNb(), threadFactoryName$1) : this.fixedExecutor(arguments$1.threadsNb(), threadFactoryName$1)));
        }
        return executorService;
    }

    private final ExecutorService executorService$1(Arguments arguments$1, boolean isSpecs2$1, String threadFactoryName$1, LazyRef executorService$lzy$1) {
        return executorService$lzy$1.initialized() ? (ExecutorService)executorService$lzy$1.value() : this.executorService$lzycompute$1(arguments$1, isSpecs2$1, threadFactoryName$1, executorService$lzy$1);
    }

    private final /* synthetic */ ScheduledExecutorService scheduledExecutorService$lzycompute$1(Arguments arguments$1, String threadFactoryName$1, LazyRef scheduledExecutorService$lzy$1) {
        ScheduledExecutorService scheduledExecutorService;
        LazyRef lazyRef = scheduledExecutorService$lzy$1;
        synchronized (lazyRef) {
            scheduledExecutorService = scheduledExecutorService$lzy$1.initialized() ? (ScheduledExecutorService)scheduledExecutorService$lzy$1.value() : (ScheduledExecutorService)scheduledExecutorService$lzy$1.initialize((Object)this.scheduledExecutor(arguments$1.scheduledThreadsNb(), threadFactoryName$1));
        }
        return scheduledExecutorService;
    }

    private final ScheduledExecutorService scheduledExecutorService$1(Arguments arguments$1, String threadFactoryName$1, LazyRef scheduledExecutorService$lzy$1) {
        return scheduledExecutorService$lzy$1.initialized() ? (ScheduledExecutorService)scheduledExecutorService$lzy$1.value() : this.scheduledExecutorService$lzycompute$1(arguments$1, threadFactoryName$1, scheduledExecutorService$lzy$1);
    }

    private final /* synthetic */ ExecutionContextExecutorService executionContext$lzycompute$1(Arguments arguments$1, Function1 systemLogger$1, boolean isSpecs2$1, String threadFactoryName$1, LazyRef executorService$lzy$1, LazyRef executionContext$lzy$1) {
        ExecutionContextExecutorService executionContextExecutorService;
        LazyRef lazyRef = executionContext$lzy$1;
        synchronized (lazyRef) {
            executionContextExecutorService = executionContext$lzy$1.initialized() ? (ExecutionContextExecutorService)executionContext$lzy$1.value() : (ExecutionContextExecutorService)executionContext$lzy$1.initialize((Object)this.createExecutionContext(this.executorService$1(arguments$1, isSpecs2$1, threadFactoryName$1, executorService$lzy$1), arguments$1.verbose(), (Function1<String, BoxedUnit>)systemLogger$1));
        }
        return executionContextExecutorService;
    }

    private final ExecutionContextExecutorService executionContext$1(Arguments arguments$1, Function1 systemLogger$1, boolean isSpecs2$1, String threadFactoryName$1, LazyRef executorService$lzy$1, LazyRef executionContext$lzy$1) {
        return executionContext$lzy$1.initialized() ? (ExecutionContextExecutorService)executionContext$lzy$1.value() : this.executionContext$lzycompute$1(arguments$1, systemLogger$1, isSpecs2$1, threadFactoryName$1, executorService$lzy$1, executionContext$lzy$1);
    }

    private ExecutorServices$() {
        MODULE$ = this;
    }
}

