/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.reporter;

import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.regex.Pattern;
import org.specs2.concurrent.ExecutionEnv;
import org.specs2.control.Action;
import org.specs2.control.Action$;
import org.specs2.control.Executable$;
import org.specs2.control.Logger;
import org.specs2.control.Operation;
import org.specs2.control.Operation$;
import org.specs2.control.origami.Fold;
import org.specs2.control.origami.Folds$;
import org.specs2.fp.Applicative;
import org.specs2.fp.Functor;
import org.specs2.fp.Monad;
import org.specs2.fp.Traverse;
import org.specs2.fp.package;
import org.specs2.html.HtmlTemplate$;
import org.specs2.html.SpecHtmlPage$;
import org.specs2.html.TableOfContents$;
import org.specs2.io.DirectoryPath;
import org.specs2.io.DirectoryPath$;
import org.specs2.io.FileName$;
import org.specs2.io.FilePath;
import org.specs2.io.FilePathReader$;
import org.specs2.io.FileSystem;
import org.specs2.io.package$;
import org.specs2.main.Arguments;
import org.specs2.reporter.HtmlBodyPrinter$;
import org.specs2.reporter.HtmlOptions;
import org.specs2.reporter.HtmlOptions$;
import org.specs2.reporter.HtmlPrinter$;
import org.specs2.reporter.Pandoc;
import org.specs2.reporter.Pandoc$;
import org.specs2.reporter.Printer;
import org.specs2.reporter.SearchPage;
import org.specs2.specification.core.Env;
import org.specs2.specification.core.Fragments$;
import org.specs2.specification.core.SpecStructure;
import org.specs2.specification.core.SpecStructure$;
import org.specs2.specification.process.Statistics$;
import org.specs2.specification.process.Stats;
import org.specs2.time.SimpleTimer;
import org.specs2.time.SimpleTimer$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class HtmlPrinter
implements Printer,
Product,
Serializable {
    private final Env env;
    private final SearchPage searchPage;
    private final Logger logger;

    public static String RunAborted() {
        return HtmlPrinter$.MODULE$.RunAborted();
    }

    public static HtmlPrinter apply(Env env, SearchPage searchPage, Logger logger) {
        return HtmlPrinter$.MODULE$.apply(env, searchPage, logger);
    }

    public static HtmlPrinter fromProduct(Product product) {
        return HtmlPrinter$.MODULE$.fromProduct(product);
    }

    public static HtmlPrinter unapply(HtmlPrinter htmlPrinter) {
        return HtmlPrinter$.MODULE$.unapply(htmlPrinter);
    }

    public static Logger $lessinit$greater$default$3() {
        return HtmlPrinter$.MODULE$.$lessinit$greater$default$3();
    }

    public HtmlPrinter(Env env, SearchPage searchPage, Logger logger) {
        this.env = env;
        this.searchPage = searchPage;
        this.logger = logger;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HtmlPrinter)) return false;
        HtmlPrinter htmlPrinter = (HtmlPrinter)object;
        Env env = this.env();
        Env env2 = htmlPrinter.env();
        if (env == null) {
            if (env2 != null) {
                return false;
            }
        } else if (!env.equals(env2)) return false;
        SearchPage searchPage = this.searchPage();
        SearchPage searchPage2 = htmlPrinter.searchPage();
        if (searchPage == null) {
            if (searchPage2 != null) {
                return false;
            }
        } else if (!((Object)searchPage).equals(searchPage2)) return false;
        Logger logger = this.logger();
        Logger logger2 = htmlPrinter.logger();
        if (logger == null) {
            if (logger2 != null) {
                return false;
            }
        } else if (!logger.equals(logger2)) return false;
        if (!htmlPrinter.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HtmlPrinter;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "HtmlPrinter";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "env";
                break;
            }
            case 1: {
                string = "searchPage";
                break;
            }
            case 2: {
                string = "logger";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Env env() {
        return this.env;
    }

    public SearchPage searchPage() {
        return this.searchPage;
    }

    public Logger logger() {
        return this.logger;
    }

    public Action<BoxedUnit> prepare(List<SpecStructure> specifications) {
        return Action$.MODULE$.unit();
    }

    public Action<BoxedUnit> finalize(List<SpecStructure> specifications) {
        return ((Operation)package.syntax$.MODULE$.MonadOps(this.getHtmlOptions(this.env().arguments()), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater$eq((Function1 & Serializable)options -> (Operation)package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.when(this.searchPage().createIndex(this.env(), specifications, (HtmlOptions)options), options.search(), (Applicative)Operation.OperationMonad$.MODULE$), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater(package.syntax$.MODULE$.when((Object)TableOfContents$.MODULE$.createToc(this.env(), (List)specifications, options.outDir(), options.tocEntryMaxSize(), this.env().fileSystem()), options.toc(), (Applicative)Operation.OperationMonad$.MODULE$)), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater(package.syntax$.MODULE$.when(this.reportMissingSeeRefs(specifications, options.outDir(), this.env().specs2ExecutionEnv()), options.warnMissingSeeRefs(), (Applicative)Operation.OperationMonad$.MODULE$)))).toAction();
    }

    public Fold sink(SpecStructure spec) {
        return Statistics$.MODULE$.fold().zip(Folds$.MODULE$.list().into(Action$.MODULE$.given_NaturalTransformation_Id_Action(), (Monad)Action.ActionMonad$.MODULE$)).zip(SimpleTimer$.MODULE$.timerFold().into(Action$.MODULE$.given_NaturalTransformation_Id_Action(), (Monad)Action.ActionMonad$.MODULE$)).$less$times(Folds$.MODULE$.fromStart((Object)((Operation)package.syntax$.MODULE$.void(package.syntax$.MODULE$.MonadOps(this.getHtmlOptions(this.env().arguments()), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater$eq((Function1 & Serializable)options -> this.copyResources(this.env(), (HtmlOptions)options)), (Functor)Operation.OperationMonad$.MODULE$)).toAction(), (Monad)Action.ActionMonad$.MODULE$)).mapFlatten((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$12;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            Stats stats = (Stats)tuple2._1();
            List fragments = (List)tuple2._2();
            SimpleTimer timer = (SimpleTimer)tuple22._2();
            SpecStructure executedSpec = spec.copy(spec.copy$default$1(), spec.copy$default$2(), (Function0 & Serializable)() -> Fragments$.MODULE$.apply((Seq)fragments));
            return Pandoc$.MODULE$.getPandoc(this.env()).flatMap((Function1 & Serializable)x$1 -> {
                Action action;
                Option option = x$1;
                if (option instanceof Some) {
                    Pandoc pandoc = (Pandoc)((Some)option).value();
                    action = this.printHtmlWithPandoc(this.env(), executedSpec, stats, timer, pandoc).toAction();
                } else {
                    action = this.printHtml(this.env(), executedSpec, stats, timer).toAction();
                }
                return action;
            });
        });
    }

    public Operation<BoxedUnit> printHtml(Env env, SpecStructure spec, Stats stats, SimpleTimer timer) {
        return this.getHtmlOptions(env.arguments()).flatMap((Function1 & Serializable)options -> env.fileSystem().readFile(options.template()).$bar$bar$bar(this.logger().warnAndFail("No template file found at " + options.template().path(), HtmlPrinter$.MODULE$.RunAborted(), this.logger().warnAndFail$default$3())).flatMap((Function1 & Serializable)template -> this.makeHtml((String)template, spec, stats, timer, (HtmlOptions)options, env.arguments(), env.specs2ExecutionEnv()).flatMap((Function1 & Serializable)content -> env.fileSystem().writeFile(SpecHtmlPage$.MODULE$.outputPath(options.outDir(), spec), content).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }))));
    }

    public Operation<HtmlOptions> getHtmlOptions(Arguments arguments) {
        DirectoryPath out = arguments.commandLine().directoryOr("html.outdir", HtmlOptions$.MODULE$.outDir());
        DirectoryPath directoryPath = arguments.commandLine().directoryOr("html.basedir", HtmlOptions$.MODULE$.baseDir());
        FilePath filePath = arguments.commandLine().fileOr("html.template", HtmlOptions$.MODULE$.template(out));
        Map map = arguments.commandLine().mapOr("html.variables", HtmlOptions$.MODULE$.variables());
        boolean bl = arguments.commandLine().boolOr("html.nostats", HtmlOptions$.MODULE$.noStats());
        boolean bl2 = arguments.commandLine().boolOr("html.search", HtmlOptions$.MODULE$.search());
        boolean bl3 = arguments.commandLine().boolOr("html.toc", HtmlOptions$.MODULE$.toc());
        int n = arguments.commandLine().intOr("html.toc.entrymaxsize", HtmlOptions$.MODULE$.tocEntryMaxSize());
        boolean bl4 = arguments.commandLine().boolOr("html.warn.missingseerefs", HtmlOptions$.MODULE$.warnMissingSeeRefs());
        return Operation$.MODULE$.ok((Object)HtmlOptions$.MODULE$.apply(out, directoryPath, filePath, (Map<String, String>)map, bl, bl2, bl4, n, bl3));
    }

    public Operation<String> makeHtml(String template, SpecStructure spec, Stats stats, SimpleTimer timer, HtmlOptions options, Arguments arguments, ExecutionEnv ee) {
        return HtmlBodyPrinter$.MODULE$.makeBody(spec, stats, timer, options, arguments, true, ee).flatMap((Function1 & Serializable)body -> {
            Map variables1 = (Map)options.templateVariables().updated((Object)"body", body).updated((Object)"title", (Object)spec.wordsTitle()).updated((Object)"path", (Object)SpecHtmlPage$.MODULE$.outputPath(options.outDir(), spec).path());
            return HtmlTemplate$.MODULE$.runTemplate(template, (Map<String, String>)variables1);
        });
    }

    public Operation<BoxedUnit> printHtmlWithPandoc(Env env, SpecStructure spec, Stats stats, SimpleTimer timer, Pandoc pandoc) {
        return this.getHtmlOptions(env.arguments()).flatMap((Function1 & Serializable)options -> env.fileSystem().withEphemeralFile(options.outDir().$bar(options.template().name()), (Operation)package.syntax$.MODULE$.MonadOps((Object)env.fileSystem().copyFile(options.outDir(), options.template()).$bar$bar$bar(this.logger().warnAndFail("No template file found at " + options.template().path(), HtmlPrinter$.MODULE$.RunAborted(), this.logger().warnAndFail$default$3())), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater(this.makePandocHtml(spec, stats, timer, pandoc, (HtmlOptions)options, env))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }));
    }

    public Operation<BoxedUnit> makePandocHtml(SpecStructure spec, Stats stats, SimpleTimer timer, Pandoc pandoc, HtmlOptions options, Env env) {
        Map variables1 = (Map)options.templateVariables().updated((Object)"title", (Object)spec.wordsTitle());
        FilePath bodyFile = options.outDir().$bar(FileName$.MODULE$.unsafe("body-" + spec.hashCode()));
        FilePath outputFilePath = SpecHtmlPage$.MODULE$.outputPath(options.outDir(), spec);
        Seq<String> pandocArguments = Pandoc$.MODULE$.arguments(bodyFile, options.template(), (Map<String, String>)variables1, outputFilePath, pandoc);
        return env.fileSystem().withEphemeralFile(bodyFile, HtmlBodyPrinter$.MODULE$.makeBody(spec, stats, timer, options, env.arguments(), true, env.specs2ExecutionEnv()).flatMap((Function1 & Serializable)body -> (Operation)package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps((Object)env.fileSystem().writeFile(bodyFile, body), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater(package.syntax$.MODULE$.when((Object)this.logger().warn(pandoc.executable().path() + " " + pandocArguments.mkString(" "), this.logger().warn$default$2()), pandoc.verbose(), (Applicative)Operation.OperationMonad$.MODULE$)), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater((Object)Executable$.MODULE$.run(pandoc.executable(), pandocArguments)), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater((Object)env.fileSystem().replaceInFile(SpecHtmlPage$.MODULE$.outputPath(options.outDir(), spec), "<code>", "<code class=\"prettyprint\">"))));
    }

    public Operation<List<BoxedUnit>> copyResources(Env env, HtmlOptions options) {
        DirectoryPath directoryPath = package$.MODULE$.$div(FileName$.MODULE$.unsafe("org"), FileName$.MODULE$.unsafe("specs2")).$div(FileName$.MODULE$.unsafe("reporter"));
        ClassLoader classLoader = HtmlPrinter.class.getClassLoader();
        return (Operation)package.syntax$.MODULE$.MonadOps((Object)env.fileSystem().mkdirs(options.outDir()), (Monad)Operation.OperationMonad$.MODULE$).$greater$greater((Object)((Operation)package.syntax$.MODULE$.sequence((Object)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DirectoryPath[]{DirectoryPath$.MODULE$.apply(FileName$.MODULE$.unsafe("css")), DirectoryPath$.MODULE$.apply(FileName$.MODULE$.unsafe("javascript")), DirectoryPath$.MODULE$.apply(FileName$.MODULE$.unsafe("images")), DirectoryPath$.MODULE$.apply(FileName$.MODULE$.unsafe("templates"))}))).map((Function1 & Serializable)src -> this.copySpecResourcesDir(env, directoryPath, options.outDir(), classLoader, (DirectoryPath)src)), (Traverse)Traverse.listInstance$.MODULE$, (Applicative)Operation.OperationMonad$.MODULE$)).recover((Function1 & Serializable)t -> {
            String message = "Cannot copy resources to " + options.outDir().path() + "\n" + t.getMessage();
            return this.logger().warnAndFail(message, HtmlPrinter$.MODULE$.RunAborted() + message, this.logger().warnAndFail$default$3());
        }));
    }

    public Operation<BoxedUnit> copySpecResourcesDir(Env env, DirectoryPath base, DirectoryPath outputDir, ClassLoader loader, DirectoryPath src) {
        Operation operation;
        Option option = Option$.MODULE$.apply((Object)loader.getResource(base.$div(src).path()));
        if (option instanceof Some) {
            URL url = (URL)((Some)option).value();
            FileSystem fs = env.fileSystem();
            operation = url.getProtocol().equalsIgnoreCase("jar") ? fs.unjar(this.jarOf(url), outputDir, "^" + Pattern.quote(base.path()) + "(/" + Pattern.quote(src.path()) + "/.*)$") : fs.copyDir(DirectoryPath$.MODULE$.unsafe(url.toURI()), outputDir.$div(src));
        } else {
            String message = "no resource found for path " + base.$div(src).path();
            operation = this.logger().warnAndFail(message, message, this.logger().warnAndFail$default$3());
        }
        return operation;
    }

    public Operation<BoxedUnit> reportMissingSeeRefs(List<SpecStructure> specs, DirectoryPath outDir, ExecutionEnv ee) {
        return ((Operation)package.syntax$.MODULE$.filterM((List)specs.flatMap((Function1 & Serializable)_$1 -> SpecStructure$.MODULE$.seeReferencesList(_$1, ee)).distinct(), (Function1 & Serializable)ref -> FilePathReader$.MODULE$.doesNotExist(SpecHtmlPage$.MODULE$.outputPath(outDir, ref.specClassName())), (Applicative)Operation.OperationMonad$.MODULE$)).flatMap((Function1 & Serializable)missingSeeRefs -> ((Operation)package.syntax$.MODULE$.unless((Object)this.logger().warn("The following specifications are being referenced but haven't been reported\n" + ((IterableOnceOps)missingSeeRefs.map((Function1 & Serializable)_$2 -> _$2.specClassName()).distinct()).mkString("\n"), this.logger().warn$default$2()), missingSeeRefs.isEmpty(), (Applicative)Operation.OperationMonad$.MODULE$)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }));
    }

    private URL jarOf(URL url) {
        return ((JarURLConnection)url.openConnection()).getJarFileURL();
    }

    public HtmlPrinter copy(Env env, SearchPage searchPage, Logger logger) {
        return new HtmlPrinter(env, searchPage, logger);
    }

    public Env copy$default$1() {
        return this.env();
    }

    public SearchPage copy$default$2() {
        return this.searchPage();
    }

    public Logger copy$default$3() {
        return this.logger();
    }

    public Env _1() {
        return this.env();
    }

    public SearchPage _2() {
        return this.searchPage();
    }

    public Logger _3() {
        return this.logger();
    }
}

