/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.html;

import java.io.Serializable;
import java.io.StringReader;
import org.ccil.cowan.tagsoup.jaxp.SAXFactoryImpl;
import org.specs2.html.SpecHtmlPage$;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FilePath;
import org.specs2.specification.core.SpecStructure;
import org.xml.sax.InputSource;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public class SpecHtmlPage
implements Product,
Serializable {
    private final SpecStructure specification;
    private final FilePath path;
    private final DirectoryPath outDir;
    private final String content;

    public static SpecHtmlPage apply(SpecStructure specStructure, FilePath filePath, DirectoryPath directoryPath, String string) {
        return SpecHtmlPage$.MODULE$.apply(specStructure, filePath, directoryPath, string);
    }

    public static SpecHtmlPage fromProduct(Product product) {
        return SpecHtmlPage$.MODULE$.fromProduct(product);
    }

    public static FilePath outputPath(DirectoryPath directoryPath, SpecStructure specStructure) {
        return SpecHtmlPage$.MODULE$.outputPath(directoryPath, specStructure);
    }

    public static FilePath outputPath(DirectoryPath directoryPath, String string) {
        return SpecHtmlPage$.MODULE$.outputPath(directoryPath, string);
    }

    public static SpecHtmlPage unapply(SpecHtmlPage specHtmlPage) {
        return SpecHtmlPage$.MODULE$.unapply(specHtmlPage);
    }

    public SpecHtmlPage(SpecStructure specification, FilePath path, DirectoryPath outDir, String content) {
        this.specification = specification;
        this.path = path;
        this.outDir = outDir;
        this.content = content;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SpecHtmlPage)) return false;
        SpecHtmlPage specHtmlPage = (SpecHtmlPage)object;
        SpecStructure specStructure = this.specification();
        SpecStructure specStructure2 = specHtmlPage.specification();
        if (specStructure == null) {
            if (specStructure2 != null) {
                return false;
            }
        } else if (!specStructure.equals(specStructure2)) return false;
        FilePath filePath = this.path();
        FilePath filePath2 = specHtmlPage.path();
        if (filePath == null) {
            if (filePath2 != null) {
                return false;
            }
        } else if (!filePath.equals(filePath2)) return false;
        DirectoryPath directoryPath = this.outDir();
        DirectoryPath directoryPath2 = specHtmlPage.outDir();
        if (directoryPath == null) {
            if (directoryPath2 != null) {
                return false;
            }
        } else if (!directoryPath.equals(directoryPath2)) return false;
        String string = this.content();
        String string2 = specHtmlPage.content();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!specHtmlPage.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SpecHtmlPage;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "SpecHtmlPage";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "specification";
                break;
            }
            case 1: {
                string = "path";
                break;
            }
            case 2: {
                string = "outDir";
                break;
            }
            case 3: {
                string = "content";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public SpecStructure specification() {
        return this.specification;
    }

    public FilePath path() {
        return this.path;
    }

    public DirectoryPath outDir() {
        return this.outDir;
    }

    public String content() {
        return this.content;
    }

    public String className() {
        return this.specification().header().className();
    }

    public String simpleName() {
        return this.specification().header().simpleName();
    }

    public String pandocName() {
        return this.className().toLowerCase().replace(".", "-");
    }

    public String showWords() {
        return this.specification().header().showWords();
    }

    public SpecHtmlPage addToc(NodeSeq toc) {
        String replacedToc = this.content().replace("<toc/>", toc.toString());
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), replacedToc);
    }

    public FilePath relativePath() {
        return this.path().relativeTo(this.outDir());
    }

    public NodeSeq body() {
        return this.parse(this.content());
    }

    private NodeSeq parse(String string) {
        return XML$.MODULE$.withSAXParser(new SAXFactoryImpl().newSAXParser()).load(new InputSource(new StringReader(string)));
    }

    public SpecHtmlPage copy(SpecStructure specification, FilePath path, DirectoryPath outDir, String content) {
        return new SpecHtmlPage(specification, path, outDir, content);
    }

    public SpecStructure copy$default$1() {
        return this.specification();
    }

    public FilePath copy$default$2() {
        return this.path();
    }

    public DirectoryPath copy$default$3() {
        return this.outDir();
    }

    public String copy$default$4() {
        return this.content();
    }

    public SpecStructure _1() {
        return this.specification();
    }

    public FilePath _2() {
        return this.path();
    }

    public DirectoryPath _3() {
        return this.outDir();
    }

    public String _4() {
        return this.content();
    }
}

