/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.matcher;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.specs2.concurrent.ExecutionEnv;
import org.specs2.matcher.Expectable;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.Matcher;
import org.specs2.matcher.TerminationMatcher$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class TerminationMatcher<T>
implements Matcher<T> {
    private final int retries;
    private final Duration sleep;
    private final Option<Function0<Object>> whenAction;
    private final Option<String> whenDesc;
    private final boolean onlyWhen;
    private final ExecutionEnv ee;
    private final AtomicBoolean terminated;
    private final AtomicBoolean cancelled;

    public static <T> Option<Function0<Object>> $lessinit$greater$default$3() {
        return TerminationMatcher$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> Option<String> $lessinit$greater$default$4() {
        return TerminationMatcher$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> boolean $lessinit$greater$default$5() {
        return TerminationMatcher$.MODULE$.$lessinit$greater$default$5();
    }

    public TerminationMatcher(int retries, Duration sleep, Option<Function0<Object>> whenAction, Option<String> whenDesc, boolean onlyWhen, ExecutionEnv ee) {
        this.retries = retries;
        this.sleep = sleep;
        this.whenAction = whenAction;
        this.whenDesc = whenDesc;
        this.onlyWhen = onlyWhen;
        this.ee = ee;
        this.terminated = new AtomicBoolean(false);
        this.cancelled = new AtomicBoolean(false);
    }

    public <S extends T> MatchResult<S> apply(Expectable<S> a) {
        return this.retry(this.retries * this.ee.retriesFactor(), this.retries * this.ee.retriesFactor(), this.sleep.$times((double)this.ee.timeFactor()), a, this.createFuture(() -> TerminationMatcher.apply$$anonfun$1(a), this.ee), this.retry$default$6());
    }

    private final <S extends T> MatchResult<S> retry(int originalRetries, int retries, Duration sleep, Expectable<S> a, Future<S> future, boolean whenActionExecuted) {
        while (true) {
            String parameters = new StringBuilder(24).append("with retries=").append(originalRetries).append(" and sleep=").append(sleep.toMillis()).toString();
            String evenWhenAction = (String)this.whenDesc.fold(TerminationMatcher::$anonfun$1, (Function1 & Serializable)w -> new StringBuilder(11).append(" even when ").append((String)w).toString());
            String onlyWhenAction = (String)this.whenDesc.getOrElse(TerminationMatcher::$anonfun$3);
            if (this.whenAction.isDefined()) {
                if (this.terminated.get()) {
                    if (this.onlyWhen) {
                        return this.result(() -> TerminationMatcher.retry$$anonfun$1(whenActionExecuted), () -> TerminationMatcher.retry$$anonfun$2(onlyWhenAction), () -> TerminationMatcher.retry$$anonfun$3(onlyWhenAction, parameters), a);
                    }
                    return this.terminates$1(parameters, evenWhenAction, a);
                }
                if (retries <= 0) {
                    return this.blocks$1(parameters, evenWhenAction, a);
                }
                Thread.sleep(sleep.toMillis());
                if (!this.terminated.get() && !whenActionExecuted) {
                    this.whenAction.map((Function1 & Serializable)_$1 -> _$1.apply());
                    Thread.sleep(sleep.toMillis());
                    int n = retries - 1;
                    boolean bl = true;
                    retries = n;
                    whenActionExecuted = bl;
                    continue;
                }
                int n = retries - 1;
                boolean bl = this.retry$default$6();
                retries = n;
                whenActionExecuted = bl;
                continue;
            }
            if (this.terminated.get()) {
                return this.terminates$1(parameters, evenWhenAction, a);
            }
            if (retries <= 0) {
                return this.blocks$1(parameters, evenWhenAction, a);
            }
            Thread.sleep(sleep.toMillis());
            int n = retries - 1;
            boolean bl = this.retry$default$6();
            retries = n;
            whenActionExecuted = bl;
        }
    }

    private boolean retry$default$6() {
        return false;
    }

    private <A> Future<A> createFuture(Function0<A> a, ExecutionEnv ee) {
        Future future = Future$.MODULE$.apply(a, ee.executionContext());
        future.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                this.terminated.set(true);
                return;
            }
            if (try_ instanceof Failure) {
                this.terminated.set(true);
                return;
            }
            throw new MatchError((Object)try_);
        }, ee.executionContext());
        return future;
    }

    private <S> TerminationMatcher<Object> withAWhenAction(Option<Function0<S>> whenAction, Function0<Option<String>> whenDesc, boolean onlyWhen) {
        return new TerminationMatcher<Object>(this.retries, this.sleep, whenAction, (Option<String>)((Option)whenDesc.apply()), onlyWhen, this.ee);
    }

    public <S> TerminationMatcher<T> when(String actionDescription, Function0<S> action) {
        return this.withAWhenAction((Option<Function0<S>>)Some$.MODULE$.apply(action), (Function0<Option<String>>)((Function0 & Serializable)() -> TerminationMatcher.when$$anonfun$1(actionDescription)), false);
    }

    public <S> TerminationMatcher<T> onlyWhen(String actionDescription, Function0<S> action) {
        return this.withAWhenAction((Option<Function0<S>>)Some$.MODULE$.apply(action), (Function0<Option<String>>)((Function0 & Serializable)() -> TerminationMatcher.onlyWhen$$anonfun$1(actionDescription)), true);
    }

    public <S> TerminationMatcher<T> when(Function0<S> action) {
        return this.withAWhenAction((Option<Function0<S>>)Some$.MODULE$.apply(action), (Function0<Option<String>>)((Function0 & Serializable)TerminationMatcher::when$$anonfun$2), false);
    }

    public <S> TerminationMatcher<T> onlyWhen(Function0<S> action) {
        return this.withAWhenAction((Option<Function0<S>>)Some$.MODULE$.apply(action), (Function0<Option<String>>)((Function0 & Serializable)TerminationMatcher::onlyWhen$$anonfun$2), true);
    }

    private static final Object apply$$anonfun$1(Expectable a$1) {
        return a$1.value();
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final String $anonfun$3() {
        return "the second action";
    }

    private static final boolean terminates$1$$anonfun$1() {
        return true;
    }

    private static final String terminates$1$$anonfun$2() {
        return "the action terminates";
    }

    private static final String terminates$1$$anonfun$3(String parameters$2, String evenWhenAction$2) {
        return new StringBuilder(23).append("the action is blocking ").append(parameters$2).append(evenWhenAction$2).toString();
    }

    private final MatchResult terminates$1(String parameters$1, String evenWhenAction$1, Expectable a$2) {
        return this.result(TerminationMatcher::terminates$1$$anonfun$1, TerminationMatcher::terminates$1$$anonfun$2, () -> TerminationMatcher.terminates$1$$anonfun$3(parameters$1, evenWhenAction$1), a$2);
    }

    private static final boolean blocks$1$$anonfun$1() {
        return false;
    }

    private static final String blocks$1$$anonfun$2() {
        return "the action terminates";
    }

    private static final String blocks$1$$anonfun$3(String parameters$4, String evenWhenAction$4) {
        return new StringBuilder(23).append("the action is blocking ").append(parameters$4).append(evenWhenAction$4).toString();
    }

    private final MatchResult blocks$1(String parameters$3, String evenWhenAction$3, Expectable a$3) {
        this.cancelled.set(true);
        return this.result(TerminationMatcher::blocks$1$$anonfun$1, TerminationMatcher::blocks$1$$anonfun$2, () -> TerminationMatcher.blocks$1$$anonfun$3(parameters$3, evenWhenAction$3), a$3);
    }

    private static final boolean retry$$anonfun$1(boolean whenActionExecuted$tailLocal1$1) {
        return whenActionExecuted$tailLocal1$1;
    }

    private static final String retry$$anonfun$2(String onlyWhenAction$1) {
        return new StringBuilder(43).append("the action terminates only when ").append(onlyWhenAction$1).append(" terminates").toString();
    }

    private static final String retry$$anonfun$3(String onlyWhenAction$2, String parameters$5) {
        return new StringBuilder(32).append("the action terminated before ").append(onlyWhenAction$2).append(" (").append(parameters$5).append(")").toString();
    }

    private static final Option when$$anonfun$1(String actionDescription$1) {
        return Some$.MODULE$.apply((Object)actionDescription$1);
    }

    private static final Option onlyWhen$$anonfun$1(String actionDescription$2) {
        return Some$.MODULE$.apply((Object)actionDescription$2);
    }

    private static final Option when$$anonfun$2() {
        return None$.MODULE$;
    }

    private static final Option onlyWhen$$anonfun$2() {
        return None$.MODULE$;
    }
}

