/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.matcher;

import java.io.Serializable;
import org.specs2.io.FileReader;
import org.specs2.matcher.PathMatcher;
import org.specs2.text.Quote$;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;

public interface PathMatchers {
    public static void $init$(PathMatchers $this) {
        $this.org$specs2$matcher$PathMatchers$_setter_$fileReader_$eq(new FileReader(){});
    }

    public FileReader fileReader();

    public void org$specs2$matcher$PathMatchers$_setter_$fileReader_$eq(FileReader var1);

    public static PathMatcher beAnExistingPath$(PathMatchers $this) {
        return $this.beAnExistingPath();
    }

    default public PathMatcher beAnExistingPath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().exists(s), "doesn't exist");
    }

    public static PathMatcher beAReadablePath$(PathMatchers $this) {
        return $this.beAReadablePath();
    }

    default public PathMatcher beAReadablePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().canRead(s), "can't be read");
    }

    public static PathMatcher beAWritablePath$(PathMatchers $this) {
        return $this.beAWritablePath();
    }

    default public PathMatcher beAWritablePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().canWrite(s), "can't be written");
    }

    public static PathMatcher beAnAbsolutePath$(PathMatchers $this) {
        return $this.beAnAbsolutePath();
    }

    default public PathMatcher beAnAbsolutePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isAbsolute(s), "is not absolute");
    }

    public static PathMatcher beAHiddenPath$(PathMatchers $this) {
        return $this.beAHiddenPath();
    }

    default public PathMatcher beAHiddenPath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isHidden(s), "is not hidden");
    }

    public static PathMatcher beAFilePath$(PathMatchers $this) {
        return $this.beAFilePath();
    }

    default public PathMatcher beAFilePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isFile(s), "is not a file");
    }

    public static PathMatcher beADirectoryPath$(PathMatchers $this) {
        return $this.beADirectoryPath();
    }

    default public PathMatcher beADirectoryPath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isDirectory(s), "is not a directory");
    }

    public static PathMatcher havePathName$(PathMatchers $this, String name) {
        return $this.havePathName(name);
    }

    default public PathMatcher havePathName(String name) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getName(s), name), "is not named " + Quote$.MODULE$.q((Object)name));
    }

    public static PathMatcher haveAsAbsolutePath$(PathMatchers $this, String path) {
        return $this.haveAsAbsolutePath(path);
    }

    default public PathMatcher haveAsAbsolutePath(String path) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep((String)s, path), "doesn't have absolute path " + Quote$.MODULE$.q((Object)path));
    }

    public static PathMatcher haveAsCanonicalPath$(PathMatchers $this, String path) {
        return $this.haveAsCanonicalPath(path);
    }

    default public PathMatcher haveAsCanonicalPath(String path) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getCanonicalPath(s), path), "doesn't have canonical path " + Quote$.MODULE$.q((Object)path));
    }

    public static PathMatcher haveParentPath$(PathMatchers $this, String parent) {
        return $this.haveParentPath(parent);
    }

    default public PathMatcher haveParentPath(String parent) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getParent(s), parent), "doesn't have parent path " + Quote$.MODULE$.q((Object)parent));
    }

    public static PathMatcher listPaths$(PathMatchers $this, Seq list) {
        return $this.listPaths((Seq<String>)list);
    }

    default public PathMatcher listPaths(Seq<String> list) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> {
            if (list == null) return false;
            List list = this.fileReader().listFiles(s).toList();
            List list2 = list.toList();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, "doesn't have files " + Quote$.MODULE$.q((Object)list.toList().mkString(", ")));
    }

    public static PathMatcher beEqualToIgnoringSep$(PathMatchers $this, String other) {
        return $this.beEqualToIgnoringSep(other);
    }

    default public PathMatcher beEqualToIgnoringSep(String other) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getCanonicalPath(s), other), "is not equal ignoring separators to " + Quote$.MODULE$.q((Object)other));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEqualIgnoringSep(String path, String other) {
        if (path == null) return false;
        if (other == null) return false;
        String string = this.fileReader().getCanonicalPath(path).replaceAll("\\\\", "/");
        String string2 = this.fileReader().getCanonicalPath(other).replaceAll("\\\\", "/");
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }
}

