/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.scalacheck;

import java.io.Serializable;
import org.scalacheck.Gen;
import org.scalacheck.Prop;
import org.scalacheck.Prop$;
import org.scalacheck.Properties;
import org.scalacheck.Test;
import org.scalacheck.Test$;
import org.scalacheck.rng.Seed;
import org.scalacheck.rng.Seed$;
import org.scalacheck.util.FreqMap;
import org.scalacheck.util.Pretty;
import org.scalacheck.util.Pretty$;
import org.specs2.execute.DecoratedResult;
import org.specs2.execute.DecoratedResult$;
import org.specs2.execute.DecoratedResultException;
import org.specs2.execute.DecoratedResultException$;
import org.specs2.execute.Details;
import org.specs2.execute.Error$;
import org.specs2.execute.Failure;
import org.specs2.execute.Failure$;
import org.specs2.execute.FailureException;
import org.specs2.execute.FailureException$;
import org.specs2.execute.Pending;
import org.specs2.execute.PendingException;
import org.specs2.execute.PendingException$;
import org.specs2.execute.Result;
import org.specs2.execute.SkipException;
import org.specs2.execute.SkipException$;
import org.specs2.execute.Skipped;
import org.specs2.execute.Success;
import org.specs2.execute.Success$;
import org.specs2.matcher.ExpectationsCreation;
import org.specs2.scalacheck.Parameters;
import org.specs2.scalacheck.PrettyDetails$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public interface ScalaCheckPropertyCheck
extends ExpectationsCreation {
    public static Result checkProperties$(ScalaCheckPropertyCheck $this, Properties properties, Parameters parameters, Function1 prettyFreqMap) {
        return $this.checkProperties(properties, parameters, (Function1<FreqMap<Set<Object>>, Pretty>)prettyFreqMap);
    }

    default public Result checkProperties(Properties properties, Parameters parameters, Function1<FreqMap<Set<Object>>, Pretty> prettyFreqMap) {
        Prop prop = Prop$.MODULE$.apply((Function1 & Serializable)params -> Prop$.MODULE$.all((Seq)properties.properties().toList().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String n = (String)tuple2._1();
            Prop p = (Prop)tuple2._2();
            return p.$colon$bar(n);
        })).apply(params));
        return this.check(prop, parameters, prettyFreqMap);
    }

    public static Result check$(ScalaCheckPropertyCheck $this, Prop prop, Parameters parameters, Function1 prettyFreqMap) {
        return $this.check(prop, parameters, (Function1<FreqMap<Set<Object>>, Pretty>)prettyFreqMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Result check(Prop prop, Parameters parameters, Function1<FreqMap<Set<Object>>, Pretty> prettyFreqMap) {
        Object object;
        Prop prop2;
        LazyRef lazyRef = new LazyRef();
        ObjectRef capturedSeed = ObjectRef.create(null);
        Option<Seed> option = parameters.seed();
        if (option instanceof Some) {
            Seed s = (Seed)((Some)option).value();
            prop2 = prop.useSeed("specs2", s);
        } else {
            prop2 = Prop$.MODULE$.apply((Function1 & Serializable)prms0 -> {
                Tuple2 tuple2;
                Option option = prms0.initialSeed();
                if (option instanceof Some) {
                    Seed sd = (Seed)((Some)option).value();
                    tuple2 = Tuple2$.MODULE$.apply(prms0, (Object)sd);
                } else {
                    Seed sd = Seed$.MODULE$.random();
                    tuple2 = Tuple2$.MODULE$.apply((Object)prms0.withInitialSeed(sd), (Object)sd);
                }
                Tuple2 tuple22 = tuple2;
                Gen.Parameters prms = (Gen.Parameters)tuple22._1();
                Seed seed = (Seed)tuple22._2();
                Prop.Result res = prop.apply(prms);
                Seed seed2 = seed;
                capturedSeed$3.elem = seed2;
                return res;
            });
        }
        Prop prop1 = prop2;
        Test.Result result = Test$.MODULE$.check(parameters.testParameters(), prop1);
        String prettyTestResult = this.prettyResult(result, parameters, (Function0<Seed>)((Function0 & Serializable)() -> ScalaCheckPropertyCheck.$anonfun$3(parameters, capturedSeed, lazyRef)), prettyFreqMap).apply(parameters.prettyParams());
        String testResult = parameters.prettyParams().verbosity() == 0 ? "" : prettyTestResult;
        Test.Result result2 = result;
        if (result2 == null) throw new MatchError((Object)result2);
        Test.Result result3 = Test.Result$.MODULE$.unapply(result2);
        Test.Status status = result3._1();
        int n = result3._2();
        int n2 = result3._3();
        FreqMap freqMap = result3._4();
        long l = result3._5();
        if (Test.Passed$.MODULE$.equals(status)) {
            int succeeded = n;
            int discarded = n2;
            FreqMap fq = freqMap;
            object = Success$.MODULE$.apply(prettyTestResult, testResult, succeeded);
        } else if (status instanceof Test.Proved) {
            List list;
            Test.Proved proved = Test.Proved$.MODULE$.unapply((Test.Proved)status);
            List as = list = proved._1();
            int succeeded = n;
            int discarded = n2;
            FreqMap fq = freqMap;
            object = Success$.MODULE$.apply(prettyTestResult, testResult, succeeded);
        } else if (Test.Exhausted$.MODULE$.equals(status)) {
            int n3 = n;
            FreqMap fq = freqMap;
            object = Failure$.MODULE$.apply(prettyTestResult, Failure$.MODULE$.$lessinit$greater$default$2(), Failure$.MODULE$.$lessinit$greater$default$3(), Failure$.MODULE$.$lessinit$greater$default$4());
        } else if (status instanceof Test.Failed) {
            Test.Failed failed = Test.Failed$.MODULE$.unapply((Test.Failed)status);
            List list = failed._1();
            Set set = failed._2();
            List args = list;
            Set labels = set;
            int n4 = n;
            FreqMap fq = freqMap;
            object = new Failure(prettyTestResult, fq){
                {
                    Details details = PrettyDetails$.MODULE$.collectDetails(fq$1);
                    String string = Failure$.MODULE$.$lessinit$greater$default$2();
                    List list = Failure$.MODULE$.$lessinit$greater$default$3();
                    super(prettyTestResult$1, string, list, details);
                }

                public String location() {
                    return "";
                }
            };
        } else {
            DecoratedResultException decoratedResultException;
            DecoratedResult decoratedResult;
            if (!(status instanceof Test.PropException)) throw new MatchError((Object)result2);
            Test.PropException propException = Test.PropException$.MODULE$.unapply((Test.PropException)status);
            List list = propException._1();
            Throwable throwable = propException._2();
            Set set = propException._3();
            List args = list;
            Throwable ex = throwable;
            Set labels = set;
            int n5 = n;
            FreqMap fq = freqMap;
            Throwable throwable2 = ex;
            if (throwable2 instanceof FailureException) {
                Failure failure;
                FailureException failureException = FailureException$.MODULE$.unapply((FailureException)throwable2);
                Failure f = failure = failureException._1();
                String failedResult = this.prettyResult(result.copy((Test.Status)Test.Failed$.MODULE$.apply(args, labels), result.copy$default$2(), result.copy$default$3(), result.copy$default$4(), result.copy$default$5()), parameters, (Function0<Seed>)((Function0 & Serializable)() -> ScalaCheckPropertyCheck.$anonfun$4(parameters, capturedSeed, lazyRef)), prettyFreqMap).apply(parameters.prettyParams());
                String string = failedResult + "\n> " + f.message();
                String string2 = Failure$.MODULE$.$lessinit$greater$default$2();
                object = Failure$.MODULE$.apply(string, string2, f.trace(), f.details());
            } else if (throwable2 instanceof DecoratedResultException && (decoratedResult = (decoratedResultException = DecoratedResultException$.MODULE$.unapply((DecoratedResultException)throwable2))._1()) != null) {
                Result result4;
                DecoratedResult decoratedResult2 = DecoratedResult$.MODULE$.unapply(decoratedResult);
                Object object2 = decoratedResult2._1();
                Result f = result4 = decoratedResult2._2();
                String failedResult = this.prettyResult(result.copy((Test.Status)Test.Failed$.MODULE$.apply(args, labels), result.copy$default$2(), result.copy$default$3(), result.copy$default$4(), result.copy$default$5()), parameters, (Function0<Seed>)((Function0 & Serializable)() -> ScalaCheckPropertyCheck.$anonfun$5(parameters, capturedSeed, lazyRef)), prettyFreqMap).apply(parameters.prettyParams());
                object = f.setMessage(failedResult + "\n>\n" + f.message());
            } else if (throwable2 instanceof AssertionError) {
                AssertionError e = (AssertionError)((Object)throwable2);
                String failedResult = this.prettyResult(result.copy((Test.Status)Test.Failed$.MODULE$.apply(args, labels), result.copy$default$2(), result.copy$default$3(), result.copy$default$4(), result.copy$default$5()), parameters, (Function0<Seed>)((Function0 & Serializable)() -> ScalaCheckPropertyCheck.$anonfun$6(parameters, capturedSeed, lazyRef)), prettyFreqMap).apply(parameters.prettyParams());
                String string = failedResult + "\n> " + ((Throwable)((Object)e)).getMessage();
                List list2 = Predef$.MODULE$.wrapRefArray((Object[])((Throwable)((Object)e)).getStackTrace()).toList();
                String string3 = Failure$.MODULE$.$lessinit$greater$default$2();
                Details details = Failure$.MODULE$.$lessinit$greater$default$4();
                object = Failure$.MODULE$.apply(string, string3, list2, details);
            } else if (throwable2 instanceof SkipException) {
                Skipped skipped;
                SkipException skipException = SkipException$.MODULE$.unapply((SkipException)throwable2);
                Skipped s = skipped = skipException._1();
                object = s;
            } else if (throwable2 instanceof PendingException) {
                Pending pending;
                PendingException pendingException = PendingException$.MODULE$.unapply((PendingException)throwable2);
                Pending p = pending = pendingException._1();
                object = p;
            } else {
                Throwable throwable3;
                Option option2;
                if (throwable2 == null || (option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) throw new MatchError((Object)throwable2);
                Throwable t = throwable3 = (Throwable)option2.get();
                object = Error$.MODULE$.apply(prettyTestResult + this.showCause(t), t);
            }
        }
        Success checkResult = object;
        return this.checkResultFailure(() -> ScalaCheckPropertyCheck.check$$anonfun$1((Result)checkResult));
    }

    public static String showCause$(ScalaCheckPropertyCheck $this, Throwable t) {
        return $this.showCause(t);
    }

    default public String showCause(Throwable t) {
        return (String)Option$.MODULE$.apply((Object)t.getCause()).map((Function1 & Serializable)_$1 -> "\n> caused by " + _$1).getOrElse(ScalaCheckPropertyCheck::showCause$$anonfun$2);
    }

    public static String frequencies$(ScalaCheckPropertyCheck $this, FreqMap fq, Parameters parameters, Function1 prettyFreqMap) {
        return $this.frequencies((FreqMap<Set<Object>>)fq, parameters, (Function1<FreqMap<Set<Object>>, Pretty>)prettyFreqMap);
    }

    default public String frequencies(FreqMap<Set<Object>> fq, Parameters parameters, Function1<FreqMap<Set<Object>>, Pretty> prettyFreqMap) {
        boolean noCollectedValues = parameters.prettyParams().verbosity() <= 0 || fq.getRatios().map((Function1 & Serializable)_$2 -> (Set)_$2._1()).forall((Function1 & Serializable)_$3 -> {
            Set set = _$3.toSet();
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxedUnit.UNIT}));
            return !(set != null ? !set.equals(object) : object != null);
        });
        return noCollectedValues ? "" : StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("\n"), ((Pretty)prettyFreqMap.apply(PrettyDetails$.MODULE$.removeDetails(fq))).apply(parameters.prettyParams()));
    }

    public static Pretty prettyResult$(ScalaCheckPropertyCheck $this, Test.Result res, Parameters parameters, Function0 initialSeed, Function1 freqMapPretty) {
        return $this.prettyResult(res, parameters, (Function0<Seed>)initialSeed, (Function1<FreqMap<Set<Object>>, Pretty>)freqMapPretty);
    }

    default public Pretty prettyResult(Test.Result res, Parameters parameters, Function0<Seed> initialSeed, Function1<FreqMap<Set<Object>>, Pretty> freqMapPretty) {
        return Pretty$.MODULE$.apply((Function1 & Serializable)prms -> {
            String string;
            Test.Status status = res.status();
            if (status instanceof Test.Proved) {
                List list;
                Test.Proved proved = Test.Proved$.MODULE$.unapply((Test.Proved)status);
                List args = list = proved._1();
                string = "OK, proved property." + Pretty$.MODULE$.prettyArgs((Seq)args).apply(prms) + (prms.verbosity() > 1 ? ScalaCheckPropertyCheck.displaySeed$1(initialSeed, prms) : "");
            } else if (Test.Passed$.MODULE$.equals(status)) {
                string = "OK, passed " + res.succeeded() + " tests." + (prms.verbosity() > 1 ? ScalaCheckPropertyCheck.displaySeed$1(initialSeed, prms) : "");
            } else if (status instanceof Test.Failed) {
                Test.Failed failed = Test.Failed$.MODULE$.unapply((Test.Failed)status);
                List list = failed._1();
                Set set = failed._2();
                List args = list;
                Set l = set;
                string = "Falsified after " + res.succeeded() + (" passed tests.\n" + ScalaCheckPropertyCheck.labels$1(l) + Pretty$.MODULE$.prettyArgs((Seq)args).apply(prms)) + ScalaCheckPropertyCheck.displaySeed$1(initialSeed, prms);
            } else if (Test.Exhausted$.MODULE$.equals(status)) {
                string = "Gave up after only " + res.succeeded() + " passed tests. " + res.discarded() + " tests were discarded." + ScalaCheckPropertyCheck.displaySeed$1(initialSeed, prms);
            } else if (status instanceof Test.PropException) {
                Test.PropException propException = Test.PropException$.MODULE$.unapply((Test.PropException)status);
                List list = propException._1();
                Throwable throwable = propException._2();
                Set set = propException._3();
                List args = list;
                Throwable e2 = throwable;
                Set l = set;
                string = "Exception raised on property evaluation." + ScalaCheckPropertyCheck.labels$1(l) + Pretty$.MODULE$.prettyArgs((Seq)args).apply(prms) + "> Exception: " + Pretty$.MODULE$.pretty((Object)e2, prms, (Function1 & Serializable)e -> Pretty$.MODULE$.prettyThrowable(e)) + ScalaCheckPropertyCheck.displaySeed$1(initialSeed, prms);
            } else {
                throw new MatchError((Object)status);
            }
            String s = string;
            String t = prms.verbosity() <= 1 ? "" : "Elapsed time: " + Pretty$.MODULE$.prettyTime(res.time());
            String map = ((Pretty)freqMapPretty.apply((Object)res.freqMap())).apply(prms);
            return "" + s + t + map;
        });
    }

    private static Option initialSeed$lzyINIT1$1$$anonfun$1(Parameters parameters$2) {
        return parameters$2.seed();
    }

    private static Seed initialSeed$lzyINIT1$2$$anonfun$2() {
        throw new Exception("A seed could not be captured for a ScalaCheck property and no seed was set on the prop or set on the command line. Please report this issue to http://github.com/etorreborre/specs2/issues");
    }

    private static Seed initialSeed$lzyINIT1$3(Parameters parameters$1, ObjectRef capturedSeed$1, LazyRef initialSeed$lzy1$1) {
        Seed seed;
        LazyRef lazyRef = initialSeed$lzy1$1;
        synchronized (lazyRef) {
            seed = (Seed)(initialSeed$lzy1$1.initialized() ? initialSeed$lzy1$1.value() : initialSeed$lzy1$1.initialize((Object)((Seed)Option$.MODULE$.apply((Object)((Seed)capturedSeed$1.elem)).orElse(() -> ScalaCheckPropertyCheck.initialSeed$lzyINIT1$1$$anonfun$1(parameters$1)).getOrElse(ScalaCheckPropertyCheck::initialSeed$lzyINIT1$2$$anonfun$2))));
        }
        return seed;
    }

    private static Seed initialSeed$1(Parameters parameters$3, ObjectRef capturedSeed$2, LazyRef initialSeed$lzy1$2) {
        return (Seed)(initialSeed$lzy1$2.initialized() ? initialSeed$lzy1$2.value() : ScalaCheckPropertyCheck.initialSeed$lzyINIT1$3(parameters$3, capturedSeed$2, initialSeed$lzy1$2));
    }

    private static Seed $anonfun$3(Parameters parameters$4, ObjectRef capturedSeed$4, LazyRef initialSeed$lzy1$3) {
        return ScalaCheckPropertyCheck.initialSeed$1(parameters$4, capturedSeed$4, initialSeed$lzy1$3);
    }

    private static Seed $anonfun$4(Parameters parameters$5, ObjectRef capturedSeed$5, LazyRef initialSeed$lzy1$4) {
        return ScalaCheckPropertyCheck.initialSeed$1(parameters$5, capturedSeed$5, initialSeed$lzy1$4);
    }

    private static Seed $anonfun$5(Parameters parameters$6, ObjectRef capturedSeed$6, LazyRef initialSeed$lzy1$5) {
        return ScalaCheckPropertyCheck.initialSeed$1(parameters$6, capturedSeed$6, initialSeed$lzy1$5);
    }

    private static Seed $anonfun$6(Parameters parameters$7, ObjectRef capturedSeed$7, LazyRef initialSeed$lzy1$6) {
        return ScalaCheckPropertyCheck.initialSeed$1(parameters$7, capturedSeed$7, initialSeed$lzy1$6);
    }

    private static Result check$$anonfun$1(Result checkResult$1) {
        return checkResult$1;
    }

    private static String showCause$$anonfun$2() {
        return "";
    }

    private static String displaySeed$1(Function0 initialSeed$1, Pretty.Params prms$1) {
        return prms$1.verbosity() >= 0 ? "\nThe seed is " + ((Seed)initialSeed$1.apply()).toBase64() + "\n" : "";
    }

    private static String labels$1(Set ls) {
        return ls.isEmpty() ? "" : "> Labels of failing property:" + ls.mkString("\n");
    }
}

