/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.configDiscovery.maven.plugin;

import com.google.common.base.CaseFormat;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.spf4j.base.asm.Invocation;
import org.spf4j.base.asm.Scanner;
import org.spf4j.configDiscovery.maven.plugin.FieldInfo;
import org.spf4j.configDiscovery.maven.plugin.JsonUtils;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true)
public class ConfigScannerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/avdl", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifactId}.avdl", property="outputFile", required=true)
    private String fileName;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="SystemProperties")
    private String rootRecordName;
    @Parameter(defaultValue="Config")
    private String recordSuffix;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File classes;
    @Parameter(defaultValue="")
    private String namespace = "";
    private final Set<Method> methods = ConfigScannerMojo.getSystemPropertyMethods();
    public static final Map<Class, String> JAVA2AVROTYPE = new HashMap<Class, String>();

    private static Set<Method> getSystemPropertyMethods() {
        try {
            return ImmutableSet.of((Object)System.class.getDeclaredMethod("getProperty", String.class), (Object)System.class.getDeclaredMethod("getProperty", String.class, String.class), (Object)Integer.class.getDeclaredMethod("getInteger", String.class), (Object)Integer.class.getDeclaredMethod("getInteger", String.class, Integer.TYPE), (Object)Integer.class.getDeclaredMethod("getInteger", String.class, Integer.class), (Object)Long.class.getDeclaredMethod("getLong", String.class), (Object[])new Method[]{Long.class.getDeclaredMethod("getLong", String.class, Long.class), Long.class.getDeclaredMethod("getLong", String.class, Long.TYPE), Boolean.class.getDeclaredMethod("getBoolean", String.class)});
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String greatestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }

    @Nonnull
    public static String getPackageName(String className) {
        int lastIndexOf = className.lastIndexOf(47);
        if (lastIndexOf >= 0) {
            return className.substring(0, lastIndexOf).replace('/', '.');
        }
        return "";
    }

    public void processClasses(final File location, Map<String, Object> avdlWriter) throws IOException {
        block8: {
            block7: {
                if (!location.exists()) {
                    return;
                }
                if (!location.isDirectory()) break block7;
                File[] listFiles = location.listFiles();
                if (listFiles == null) break block8;
                for (File file : listFiles) {
                    this.processClasses(file, avdlWriter);
                }
                break block8;
            }
            if (location.getName().endsWith(".class")) {
                this.getLog().debug((CharSequence)("Processing class " + location));
                List invocations = Scanner.findUsages((Supplier)new Supplier<InputStream>(){

                    public InputStream get() {
                        try {
                            return new BufferedInputStream(new FileInputStream(location));
                        }
                        catch (FileNotFoundException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }, this.methods);
                for (Invocation invocation : invocations) {
                    this.getLog().debug((CharSequence)("Found invocation " + invocation));
                    Class<?> returnType = invocation.getInvokedMethod().getReturnType();
                    Object[] parameters = invocation.getParameters();
                    String caleeClassName = invocation.getCaleeClassName();
                    String doc = caleeClassName + '.' + invocation.getCaleeMethodName() + ':' + invocation.getCaleeLine();
                    Object parameter = parameters[0];
                    HashMap<String, FieldInfo<Map>> objs = avdlWriter;
                    if (parameter instanceof String) {
                        String[] attrPath = ((String)parameter).split("\\.");
                        for (int i = 0; i < attrPath.length - 1; ++i) {
                            String pv = attrPath[i];
                            HashMap<String, FieldInfo<Map>> get = (HashMap<String, FieldInfo<Map>>)objs.get(pv);
                            if (get == null) {
                                get = new HashMap<String, FieldInfo<Map>>();
                                objs.put(pv, (FieldInfo<Map>)((Object)get));
                            }
                            objs = get;
                        }
                        String fname = attrPath[attrPath.length - 1];
                        FieldInfo<Object> fi = (FieldInfo<Object>)objs.get(fname);
                        if (fi != null) continue;
                        fi = parameters.length > 1 ? new FieldInfo<Object>(ConfigScannerMojo.getPackageName(caleeClassName), doc, returnType, parameters[1]) : new FieldInfo<Object>(ConfigScannerMojo.getPackageName(caleeClassName), doc, returnType, null);
                        objs.put(fname, fi);
                        continue;
                    }
                    FieldInfo<Map> df = (FieldInfo<Map>)objs.get("dynamic");
                    df = df == null ? new FieldInfo<Map>(ConfigScannerMojo.getPackageName(caleeClassName), doc, Map.class, Collections.EMPTY_MAP) : new FieldInfo<Map>(ConfigScannerMojo.getPackageName(caleeClassName), df.getDoc() + '\n' + doc, Map.class, Collections.EMPTY_MAP);
                    objs.put("dynamic", df);
                }
            }
        }
    }

    public static String childNameSpace(String parent, String child) {
        return parent.isEmpty() ? child : parent + '.' + child;
    }

    public void writeRecord(Writer w, String nameSpace, String recordName, Map<String, Object> record) throws IOException {
        Object value;
        for (Map.Entry<String, Object> entry : record.entrySet()) {
            value = entry.getValue();
            if (value instanceof Map) {
                String key = entry.getKey();
                this.writeRecord(w, ConfigScannerMojo.childNameSpace(nameSpace, key), CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, key) + this.recordSuffix, (Map)value);
                continue;
            }
            if (value instanceof FieldInfo) continue;
            throw new IllegalStateException("Not supported type " + value);
        }
        if (!nameSpace.isEmpty()) {
            w.write(" @namespace(\"");
            w.write(nameSpace);
            w.write("\")\n");
        }
        w.write(" record ");
        w.write(recordName);
        w.write(" {\n");
        for (Map.Entry<String, Object> entry : record.entrySet()) {
            value = entry.getValue();
            if (value instanceof FieldInfo) {
                FieldInfo field = (FieldInfo)value;
                w.write("\n  /**");
                w.write(field.getDoc());
                w.write("*/\n");
                Class<?> type = field.getType();
                Object defaultValue = field.getDefaultValue();
                String avroType = JAVA2AVROTYPE.get(type);
                if (avroType == null) {
                    throw new IllegalStateException(" No avro equivalent for " + type);
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    defaultValue = false;
                }
                if (defaultValue == null) {
                    w.write("  union {null, ");
                    w.write(avroType);
                    w.write("} ");
                } else {
                    w.write("  ");
                    w.write(avroType);
                    w.write(" ");
                }
                w.write(entry.getKey());
                w.write(" = ");
                w.append(defaultValue == null ? null : (defaultValue.getClass() == String.class ? JsonUtils.toJsonString((String)defaultValue) : defaultValue.toString()));
                w.write(";\n");
                continue;
            }
            if (value instanceof Map) {
                String key = entry.getKey();
                String ns = ConfigScannerMojo.childNameSpace(nameSpace, key);
                w.write("\n /** Category: ");
                w.write(key);
                w.write(" */\n  ");
                w.write(ns);
                w.write(46);
                w.write(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, key));
                w.write(this.recordSuffix);
                w.write(" ");
                w.write(key);
                w.write(";\n");
                continue;
            }
            throw new IllegalStateException("Not supported type " + value);
        }
        w.write(" }\n\n");
    }

    public void execute() throws MojoExecutionException {
        File f = this.outputDirectory;
        if (!f.exists() && !f.mkdirs()) {
            throw new MojoExecutionException("Unable to create directory " + this.outputDirectory);
        }
        File outFile = new File(f, this.fileName);
        this.getLog().info((CharSequence)("Creating avdl file at " + outFile));
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.encoding);){
            if (this.namespace != null && !this.namespace.isEmpty()) {
                w.write("@namespace(\"");
                w.write(this.namespace);
                w.write("\")\n");
            }
            w.write("protocol  ");
            w.write(this.rootRecordName);
            w.write("Protocol");
            w.write(" {\n");
            HashMap<String, Object> record = new HashMap<String, Object>();
            this.processClasses(this.classes, record);
            this.writeRecord(w, this.namespace, this.rootRecordName, record);
            w.write("}\n");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot generate config description", (Exception)ex);
        }
    }

    static {
        JAVA2AVROTYPE.put(String.class, "string");
        JAVA2AVROTYPE.put(Integer.class, "int");
        JAVA2AVROTYPE.put(Integer.TYPE, "int");
        JAVA2AVROTYPE.put(Long.class, "long");
        JAVA2AVROTYPE.put(Long.TYPE, "long");
        JAVA2AVROTYPE.put(Boolean.class, "boolean");
        JAVA2AVROTYPE.put(Boolean.TYPE, "boolean");
        JAVA2AVROTYPE.put(Float.class, "float");
        JAVA2AVROTYPE.put(Float.TYPE, "float");
        JAVA2AVROTYPE.put(Double.class, "double");
        JAVA2AVROTYPE.put(Double.TYPE, "double");
        JAVA2AVROTYPE.put(Map.class, "map<string>");
    }
}

