/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.config_discovery.maven.plugin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;

public final class JsonUtils {
    private static final ThreadLocal<char[]> BUFF = new ThreadLocal<char[]>(){

        @Override
        @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
        protected char[] initialValue() {
            return new char[64];
        }
    };
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private JsonUtils() {
    }

    public static CharSequence toJsonString(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 4);
        sb.append('\"');
        JsonUtils.escapeJsonString(str, sb);
        sb.append('\"');
        return sb;
    }

    public static void escapeJsonString(@Nonnull String toEscape, StringBuilder jsonString) {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            JsonUtils.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void appendJsonStringEscapedChar(char c, StringBuilder jsonString) {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    JsonUtils.appendUnsignedStringPadded(jsonString, c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendUnsignedStringPadded(StringBuilder sb, int nr, int shift, int padTo) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(buf, charPos, nrChars);
    }
}

