/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.actuator.open_api;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ExtendedReflectData;
import org.spf4j.avro.schema.Schemas;

public final class AvroModelConverter
implements ModelConverter {
    public static final AvroModelConverter INSTANCE = new AvroModelConverter();
    private final ModelResolver jackson = new ModelResolver(Json.mapper());

    public io.swagger.v3.oas.models.media.Schema resolve(AnnotatedType atype, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Object actualType;
        JavaType type = atype.getType();
        if (type instanceof JavaType) {
            JavaType javaType = type;
            if (javaType.isArrayType() || javaType.isCollectionLikeType()) {
                actualType = Array.newInstance(javaType.getContentType().getRawClass(), 0).getClass();
            } else if (javaType.isTypeOrSubTypeOf(Iterable.class) && javaType.hasGenericTypes()) {
                JavaType containedType = javaType.containedType(0);
                Class<Object> rawContainedClass = containedType.getRawClass();
                if (rawContainedClass == GenericRecord.class || rawContainedClass == IndexedRecord.class) {
                    rawContainedClass = Object.class;
                }
                actualType = Array.newInstance(rawContainedClass, 0).getClass();
            } else {
                actualType = javaType;
            }
        } else {
            actualType = type;
        }
        Schema aSchema = ExtendedReflectData.get().getSchema((Type)actualType);
        if (aSchema == null) {
            return this.jackson.resolve(atype, context, chain);
        }
        return this.resolve(aSchema, new IdentityHashMap<Schema, io.swagger.v3.oas.models.media.Schema>(), context);
    }

    @Nullable
    private static Schema nullableSchema(Schema aSchema) {
        List types = aSchema.getTypes();
        if (types.size() != 2) {
            return null;
        }
        if (!Schemas.isNullableUnion((Schema)aSchema)) {
            return null;
        }
        for (Schema s : types) {
            if (s.getType() == Schema.Type.NULL) continue;
            return s;
        }
        return null;
    }

    public io.swagger.v3.oas.models.media.Schema resolve(Schema aSchema, Map<Schema, io.swagger.v3.oas.models.media.Schema> resolved, ModelConverterContext context) {
        ObjectSchema result;
        io.swagger.v3.oas.models.media.Schema get = resolved.get(aSchema);
        if (get != null) {
            return new io.swagger.v3.oas.models.media.Schema().$ref("#/components/schemas/" + aSchema.getFullName());
        }
        LogicalType logicalType = aSchema.getLogicalType();
        block0 : switch (aSchema.getType()) {
            case ARRAY: {
                result = new ArraySchema().items(this.resolve(aSchema.getElementType(), resolved, context));
                result.nullable(Boolean.FALSE);
                break;
            }
            case BOOLEAN: {
                result = PrimitiveType.BOOLEAN.createProperty().nullable(Boolean.FALSE);
                break;
            }
            case BYTES: {
                result = new BinarySchema().nullable(Boolean.FALSE);
                break;
            }
            case DOUBLE: {
                result = PrimitiveType.DOUBLE.createProperty().nullable(Boolean.FALSE);
                break;
            }
            case ENUM: {
                result = PrimitiveType.STRING.createProperty().nullable(Boolean.FALSE);
                result.setEnum(aSchema.getEnumStringSymbols());
                break;
            }
            case FIXED: {
                result = new BinarySchema().nullable(Boolean.FALSE);
                break;
            }
            case FLOAT: {
                result = PrimitiveType.FLOAT.createProperty().nullable(Boolean.FALSE);
                break;
            }
            case INT: {
                result = PrimitiveType.INT.createProperty().nullable(Boolean.FALSE);
                break;
            }
            case LONG: {
                result = PrimitiveType.LONG.createProperty().nullable(Boolean.FALSE);
                break;
            }
            case STRING: {
                if (logicalType != null) {
                    switch (logicalType.getName()) {
                        case "date": {
                            result = PrimitiveType.DATE.createProperty().nullable(Boolean.FALSE);
                            break block0;
                        }
                        case "instant": {
                            result = PrimitiveType.DATE_TIME.createProperty().nullable(Boolean.FALSE);
                            break block0;
                        }
                        case "url": {
                            result = PrimitiveType.URL.createProperty().nullable(Boolean.FALSE);
                            break block0;
                        }
                        case "uri": {
                            result = PrimitiveType.URI.createProperty().nullable(Boolean.FALSE);
                            break block0;
                        }
                        case "uuid": {
                            result = PrimitiveType.UUID.createProperty().nullable(Boolean.FALSE);
                            break block0;
                        }
                    }
                    result = PrimitiveType.STRING.createProperty().nullable(Boolean.FALSE);
                    break;
                }
                result = PrimitiveType.STRING.createProperty().nullable(Boolean.FALSE);
                break;
            }
            case NULL: {
                result = PrimitiveType.STRING.createProperty().format("").nullable(Boolean.TRUE);
                break;
            }
            case UNION: {
                Schema nullableSchema = AvroModelConverter.nullableSchema(aSchema);
                if (nullableSchema != null) {
                    result = this.resolve(nullableSchema, resolved, context);
                    result = result.nullable(Boolean.TRUE);
                    break;
                }
                ComposedSchema cs = new ComposedSchema();
                for (Schema ss : aSchema.getTypes()) {
                    if (ss.getType() == Schema.Type.NULL) {
                        cs.nullable(Boolean.TRUE);
                        continue;
                    }
                    cs.addAnyOfItem(this.resolve(ss, resolved, context));
                }
                result = cs;
                break;
            }
            case RECORD: {
                result = new ObjectSchema();
                resolved.put(aSchema, (io.swagger.v3.oas.models.media.Schema)result);
                context.defineModel(aSchema.getFullName(), (io.swagger.v3.oas.models.media.Schema)result);
                for (Schema.Field field : aSchema.getFields()) {
                    io.swagger.v3.oas.models.media.Schema fs = this.resolve(field.schema(), resolved, context);
                    fs = fs.description(field.doc() + "; " + fs.getDescription());
                    result.addProperties(field.name(), fs);
                }
                result.nullable(Boolean.FALSE);
                break;
            }
            case MAP: {
                result = new MapSchema();
                result.addExtension("avsc", (Object)aSchema);
                result.nullable(Boolean.FALSE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported schema type " + aSchema);
            }
        }
        if (aSchema.getProp("deprecated") != null) {
            result.deprecated(Boolean.TRUE);
        }
        return result.description((aSchema.getProp("beta") != null ? "Beta model; " : "") + aSchema.getDoc());
    }
}

