/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.actuator.open_api;

import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.filter.AbstractSpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spf4j.log.Level;
import org.spf4j.service.avro.ServiceError;

public final class DefaultAspectsApiFilter
extends AbstractSpecFilter {
    public Optional<OpenAPI> filterOpenAPI(OpenAPI openAPI, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        HashMap schemas;
        Components components = openAPI.getComponents();
        if (components == null) {
            components = new Components();
            openAPI.setComponents(components);
        }
        if ((schemas = components.getSchemas()) == null) {
            schemas = new HashMap(4);
            components.setSchemas(schemas);
        }
        schemas.putAll(ModelConverters.getInstance().readAll(ServiceError.class));
        Paths np = new Paths();
        openAPI.getPaths().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            PathItem cfr_ignored_0 = (PathItem)np.put(entry.getKey(), entry.getValue());
        });
        openAPI.setPaths(np);
        return Optional.of(openAPI);
    }

    public Optional<Operation> filterOperation(Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        ApiResponses responses = operation.getResponses();
        ArrayList<Parameter> parameters = operation.getParameters();
        if (parameters == null) {
            parameters = new ArrayList<Parameter>(4);
            operation.setParameters(parameters);
        }
        parameters.add(new Parameter().required(Boolean.FALSE).name("request-timeout").in("header").description("request-timeout \u2192 TimeoutValue TimeoutUnit?\n TimeoutValue \u2192 {positive integer as ASCII string of at most 8 digits}\n TimeoutUnit \u2192 Hour / Minute / Second / Millisecond / Microsecond / Nanosecond\n Hour \u2192 \"H\"\n Minute \u2192 \"M\"\n Second \u2192 \"S\"\n Millisecond \u2192 \"m\"\n Microsecond \u2192 \"u\"\n Nanosecond \u2192 \"n\"").schema(PrimitiveType.STRING.createProperty()));
        parameters.add(new Parameter().required(Boolean.FALSE).name("request-deadline").in("header").description("request-deadline \u2192 SecondsSinceEpoch Nanos? ; this header takes precendence to request-timeout").schema(PrimitiveType.STRING.createProperty()));
        parameters.add(new Parameter().description("Request context log level").required(Boolean.FALSE).name("log-level").in("header").schema(ModelConverters.getInstance().readAllAsResolvedSchema(Level.class).schema));
        parameters.add(new Parameter().description("Request id, if not provided server will generate one").required(Boolean.FALSE).name("request-id").in("header").schema(PrimitiveType.STRING.createProperty().description("Request ID")));
        responses.addApiResponse("500", new ApiResponse().description("standard error response").content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref("#/components/schemas/" + ServiceError.getClassSchema().getFullName())))));
        return Optional.of(operation);
    }
}

