/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.actuator.open_api;

import gnu.trove.set.hash.THashSet;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.v3.jaxrs2.integration.resources.BaseOpenApiResource;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.actuator.open_api.AvroModelConverter;
import org.spf4j.actuator.open_api.CustomReader;
import org.spf4j.actuator.open_api.DefaultAspectsApiFilter;

@Path(value="/")
@Singleton
@PermitAll
public final class OpenApiResource
extends BaseOpenApiResource {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiResource.class);
    private final ServletConfig config;

    @Inject
    public OpenApiResource(@Context ServletConfig config) {
        this.config = config;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="openapi.json")
    public Response getOpenApi(@Context HttpHeaders headers, @Context UriInfo uriInfo, @Context Application app) throws Exception {
        return this.getOpenApi(headers, this.config, app, uriInfo, "json");
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="openapi.yaml")
    public Response getOpenApiYaml(@Context HttpHeaders headers, @Context UriInfo uriInfo, @Context Application app) throws Exception {
        return this.getOpenApi(headers, this.config, app, uriInfo, "yaml");
    }

    protected Response getOpenApi(HttpHeaders headers, ServletConfig servletConfig, Application application, UriInfo uriInfo, String type) throws Exception {
        SpecFilter f;
        ServletContainer cont;
        String ctxId = ServletConfigContextUtils.getContextIdFromServletConfig((ServletConfig)servletConfig);
        if (this.resourcePackages == null) {
            this.resourcePackages = ServletConfigContextUtils.resolveResourcePackages((ServletConfig)servletConfig);
        }
        Set resources = (cont = (ServletContainer)application.getProperties().get(ServletContainer.class.getName())) == null ? application.getClasses() : cont.getConfiguration().getClasses();
        Set strClasses = (Set)resources.stream().map(Class::getName).collect(Collectors.toCollection(() -> new THashSet(resources.size())));
        if (this.openApiConfiguration == null) {
            SwaggerConfiguration cfg = new SwaggerConfiguration().resourcePackages(this.resourcePackages).filterClass(ServletConfigContextUtils.getInitParam((ServletConfig)servletConfig, (String)"openApi.configuration.filterClass")).resourceClasses(strClasses).readAllResources(ServletConfigContextUtils.getBooleanInitParam((ServletConfig)servletConfig, (String)"openApi.configuration.readAllResources")).prettyPrint(ServletConfigContextUtils.getBooleanInitParam((ServletConfig)servletConfig, (String)"openApi.configuration.prettyPrint")).readerClass(CustomReader.class.getName()).cacheTTL(ServletConfigContextUtils.getLongInitParam((ServletConfig)servletConfig, (String)"openApi.configuration.cacheTTL")).scannerClass(ServletConfigContextUtils.getInitParam((ServletConfig)servletConfig, (String)"openApi.configuration.scannerClass")).objectMapperProcessorClass(ServletConfigContextUtils.getInitParam((ServletConfig)servletConfig, (String)"openApi.configuration.objectMapperProcessorClass")).modelConverterClasses(ServletConfigContextUtils.resolveModelConverterClasses((ServletConfig)servletConfig));
            cfg.setId(ctxId);
            this.openApiConfiguration = cfg;
        }
        OpenApiContext ctx = new JaxrsOpenApiContextBuilder().servletConfig(servletConfig).application(application).resourcePackages(this.resourcePackages).openApiConfiguration(this.openApiConfiguration).ctxId(ctxId).buildContext(true);
        OpenAPI oas = ctx.read();
        final boolean pretty = Boolean.TRUE.equals(ctx.getOpenApiConfiguration().isPrettyPrint());
        if (oas != null && ctx.getOpenApiConfiguration().getFilterClass() != null) {
            try {
                OpenAPISpecFilter filterImpl = (OpenAPISpecFilter)Class.forName(ctx.getOpenApiConfiguration().getFilterClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
                SpecFilter f2 = new SpecFilter();
                oas = f2.filter(oas, filterImpl, OpenApiResource.getQueryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), OpenApiResource.getCookies(headers), OpenApiResource.getHeaders(headers));
            }
            catch (Exception e) {
                LOG.error("failed to load filter", (Throwable)e);
            }
        }
        if ((oas = (f = new SpecFilter()).filter(oas, (OpenAPISpecFilter)new DefaultAspectsApiFilter(), OpenApiResource.getQueryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), OpenApiResource.getCookies(headers), OpenApiResource.getHeaders(headers))) == null) {
            return Response.status((int)404).build();
        }
        final OpenAPI result = oas;
        if (StringUtils.isNotBlank((CharSequence)type) && type.trim().equalsIgnoreCase("yaml")) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new StreamingOutput(){

                public void write(OutputStream os) throws IOException {
                    if (pretty) {
                        Yaml.pretty().writeValue(os, (Object)result);
                    } else {
                        Yaml.mapper().writeValue(os, (Object)result);
                    }
                }
            }).type("application/yaml").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new StreamingOutput(){

            public void write(OutputStream os) throws IOException {
                if (pretty) {
                    Json.pretty().writeValue(os, (Object)result);
                } else {
                    Json.mapper().writeValue(os, (Object)result);
                }
            }
        }).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static Map<String, List<String>> getQueryParams(MultivaluedMap<String, String> params) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (params != null) {
            for (String key : params.keySet()) {
                List values = (List)params.get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }

    private static Map<String, String> getCookies(HttpHeaders headers) {
        HashMap<String, String> output = new HashMap<String, String>();
        if (headers != null) {
            for (String key : headers.getCookies().keySet()) {
                Cookie cookie = (Cookie)headers.getCookies().get(key);
                output.put(key, cookie.getValue());
            }
        }
        return output;
    }

    private static Map<String, List<String>> getHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (headers != null) {
            for (String key : headers.getRequestHeaders().keySet()) {
                List values = (List)headers.getRequestHeaders().get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }

    static {
        ModelConverters.getInstance().addConverter((ModelConverter)AvroModelConverter.INSTANCE);
    }
}

