/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.builders;

import java.io.IOException;
import org.spincast.shaded.org.apache.http.Header;
import org.spincast.shaded.org.apache.http.HttpClientConnection;
import org.spincast.shaded.org.apache.http.HttpException;
import org.spincast.shaded.org.apache.http.HttpRequest;
import org.spincast.shaded.org.apache.http.HttpResponse;
import org.spincast.shaded.org.apache.http.protocol.HttpContext;
import org.spincast.shaded.org.apache.http.protocol.HttpRequestExecutor;
import org.spincast.shaded.org.apache.http.util.Args;

public class SpincastHttpRequestExecutor
extends HttpRequestExecutor {
    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)conn, (String)"Client connection");
        Args.notNull((Object)context, (String)"HTTP context");
        HttpResponse response = null;
        int statusCode = 0;
        while (response == null || statusCode < 200) {
            response = conn.receiveResponseHeader();
            if (this.canResponseHaveBody(request, response)) {
                conn.receiveResponseEntity(response);
            }
            statusCode = response.getStatusLine().getStatusCode();
            if (!this.isWebsocketUpgrade(response)) continue;
            break;
        }
        return response;
    }

    protected boolean isWebsocketUpgrade(HttpResponse response) {
        Header upgradeHeader;
        int statusCode;
        return response != null && (statusCode = response.getStatusLine().getStatusCode()) == 101 && (upgradeHeader = response.getFirstHeader("Upgrade")) != null && "WebSocket".equalsIgnoreCase(upgradeHeader.getValue());
    }
}

