/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.processutils;

import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.ResourceInfo;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.processutils.JarExecutionHandler;
import org.spincast.plugins.processutils.MavenProjectGoal;
import org.spincast.plugins.processutils.SpincastProcessUtils;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastProcessUtilsDefault
implements SpincastProcessUtils {
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final TemplatingEngine templatingEngine;

    @Inject
    public SpincastProcessUtilsDefault(SpincastConfig spincastConfig, SpincastUtils spincastUtils, TemplatingEngine templatingEngine) {
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.templatingEngine = templatingEngine;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected TemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    @Override
    public File executeGoalOnExternalMavenProject(ResourceInfo projectRootInfo, MavenProjectGoal mavenGoal) {
        return this.executeGoalOnExternalMavenProject(projectRootInfo, mavenGoal, null);
    }

    @Override
    public File executeGoalOnExternalMavenProject(ResourceInfo projectRootInfo, MavenProjectGoal mavenGoal, Map<String, Object> pomParams) {
        try {
            File projectTargetDir = null;
            if (!projectRootInfo.isClasspathResource()) {
                projectTargetDir = new File(projectRootInfo.getPath());
            } else {
                projectTargetDir = new File(this.getSpincastConfig().getTempDir(), UUID.randomUUID().toString());
                this.getSpincastUtils().copyClasspathDirToFileSystem(projectRootInfo.getPath(), projectTargetDir);
            }
            File pomFile = new File(projectTargetDir, "pom.xml");
            if (!pomFile.isFile()) {
                throw new RuntimeException("The project's pom.xml was not found: " + pomFile.getAbsolutePath());
            }
            if (pomParams != null && pomParams.size() > 0) {
                String pomContent = FileUtils.readFileToString((File)pomFile, (String)"UTF-8");
                pomContent = this.getTemplatingEngine().evaluate(pomContent, pomParams);
                FileUtils.write((File)pomFile, (CharSequence)pomContent, (String)"UTF-8");
            }
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(pomFile);
            request.setGoals(Collections.singletonList(mavenGoal.getValue()));
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.execute((InvocationRequest)request);
            return projectTargetDir;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public void executeJar(String jarFilePath, List<String> args, JarExecutionHandler handler) {
        this.executeJar("java", jarFilePath, args, handler);
    }

    @Override
    public void executeJar(final String javaBinPath, final String jarFilePath, final List<String> args, final JarExecutionHandler handler) {
        if (handler == null) {
            throw new RuntimeException("The handler can't be null");
        }
        final boolean[] exceptionOccured = new boolean[]{false};
        Thread jarExecutionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Process jarProcess = null;
                try {
                    ArrayList<String> cmdArgs = new ArrayList<String>();
                    cmdArgs.add(0, javaBinPath);
                    cmdArgs.add(1, "-jar");
                    cmdArgs.add(2, jarFilePath);
                    if (args != null && args.size() > 0) {
                        cmdArgs.addAll(args);
                    }
                    ProcessBuilder pb = new ProcessBuilder(cmdArgs);
                    pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                    pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                    jarProcess = pb.start();
                    handler.setJarProcess(jarProcess);
                    jarProcess.waitFor();
                    int exitVal = jarProcess.exitValue();
                    handler.onExit(exitVal);
                }
                catch (Exception ex) {
                    exceptionOccured[0] = true;
                    handler.onException(ex);
                }
            }
        });
        jarExecutionThread.start();
        while (!exceptionOccured[0] && handler.getJarProcess() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

