/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.utils;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.spincast.core.exceptions.CantCompareException;
import org.spincast.core.exceptions.CantConvertException;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.ToJsonArrayConvertible;
import org.spincast.core.json.ToJsonObjectConvertible;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.shaded.org.apache.commons.codec.binary.Base64;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class ObjectConverterDefault
implements ObjectConverter {
    private final JsonManager jsonManager;

    @Inject
    public ObjectConverterDefault(JsonManager jsonManager) {
        this.jsonManager = jsonManager;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    @Override
    public boolean isCanBeConvertedTo(Class<?> referenceType, Object elementToValidate) {
        if (referenceType == null || elementToValidate == null) {
            return true;
        }
        if (String.class.equals(referenceType)) {
            return this.isCanBeConvertedToString(elementToValidate);
        }
        if (BigDecimal.class.equals(referenceType)) {
            return this.isCanBeConvertedToBigDecimal(elementToValidate);
        }
        if (Boolean.class.equals(referenceType)) {
            return this.isCanBeConvertedToBoolean(elementToValidate);
        }
        if (byte[].class.equals(referenceType) || Byte[].class.equals(referenceType)) {
            return this.isCanBeConvertedToByteArray(elementToValidate);
        }
        if (Date.class.equals(referenceType)) {
            return this.isCanBeConvertedToDateFromJsonDateFormat(elementToValidate);
        }
        if (Double.class.equals(referenceType)) {
            return this.isCanBeConvertedToDouble(elementToValidate);
        }
        if (Float.class.equals(referenceType)) {
            return this.isCanBeConvertedToFloat(elementToValidate);
        }
        if (Integer.class.equals(referenceType)) {
            return this.isCanBeConvertedToInteger(elementToValidate);
        }
        if (JsonArray.class.equals(referenceType)) {
            return this.isCanBeConvertedToJsonArray(elementToValidate);
        }
        if (JsonObject.class.equals(referenceType)) {
            return this.isCanBeConvertedToJsonObject(elementToValidate);
        }
        if (Long.class.equals(referenceType)) {
            return this.isCanBeConvertedToLong(elementToValidate);
        }
        return false;
    }

    @Override
    public boolean isCanBeConvertedToString(Object object) {
        try {
            this.convertToString(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToInteger(Object object) {
        try {
            this.convertToInteger(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToLong(Object object) {
        try {
            this.convertToLong(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToFloat(Object object) {
        try {
            this.convertToFloat(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToDouble(Object object) {
        try {
            this.convertToDouble(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToBoolean(Object object) {
        try {
            this.convertToBoolean(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToBigDecimal(Object object) {
        try {
            this.convertToBigDecimal(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToByteArray(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof byte[]) {
            return true;
        }
        if (!(object instanceof String)) {
            return false;
        }
        return Base64.isBase64((String)object);
    }

    @Override
    public boolean isCanBeConvertedToDateFromJsonDateFormat(Object object) {
        try {
            this.convertToDateFromJsonDateFormat(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToJsonObject(Object object) {
        try {
            this.convertToJsonObject(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isCanBeConvertedToJsonArray(Object object) {
        try {
            this.convertToJsonArray(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isBase64StringOrNull(Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof String)) {
            return false;
        }
        try {
            this.convertBase64StringToByteArray(object);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public JsonObject convertToJsonObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        if (object instanceof ToJsonObjectConvertible) {
            return ((ToJsonObjectConvertible)object).convertToJsonObject();
        }
        try {
            JsonObject jsonObject = this.getJsonManager().fromString(object.toString());
            return jsonObject;
        }
        catch (Exception ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), JsonObject.class.getSimpleName(), object);
        }
    }

    @Override
    public JsonArray convertToJsonArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        if (object instanceof ToJsonArrayConvertible) {
            return ((ToJsonArrayConvertible)object).convertToJsonArray();
        }
        try {
            JsonArray jsonArray = this.getJsonManager().fromStringArray(object.toString());
            return jsonArray;
        }
        catch (Exception ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), JsonArray.class.getSimpleName(), object);
        }
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    @Override
    public Integer convertToInteger(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        try {
            String asString = String.valueOf(object);
            int pos = asString.lastIndexOf(".");
            if (pos > -1) {
                String decimals = asString.substring(pos + 1);
                if (StringUtils.containsOnly((CharSequence)decimals, "0")) {
                    asString = asString.substring(0, pos);
                } else {
                    throw new NumberFormatException();
                }
            }
            return Integer.valueOf(asString);
        }
        catch (NumberFormatException ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), Integer.class.getSimpleName(), object);
        }
    }

    @Override
    public Long convertToLong(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        try {
            String asString = String.valueOf(object);
            int pos = asString.lastIndexOf(".");
            if (pos > -1) {
                String decimals = asString.substring(pos + 1);
                if (StringUtils.containsOnly((CharSequence)decimals, "0")) {
                    asString = asString.substring(0, pos);
                } else {
                    throw new NumberFormatException();
                }
            }
            return Long.valueOf(asString);
        }
        catch (NumberFormatException ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), Long.class.getSimpleName(), object);
        }
    }

    @Override
    public Float convertToFloat(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        try {
            return Float.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), Float.class.getSimpleName(), object);
        }
    }

    @Override
    public Double convertToDouble(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        try {
            return Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), Double.class.getSimpleName(), object);
        }
    }

    @Override
    public Boolean convertToBoolean(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String valStr = String.valueOf(object);
        if ("true".equalsIgnoreCase(valStr)) {
            return true;
        }
        if ("false".equalsIgnoreCase(valStr)) {
            return false;
        }
        throw new CantConvertException(object.getClass().getSimpleName(), Boolean.class.getSimpleName(), object);
    }

    @Override
    public BigDecimal convertToBigDecimal(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        try {
            return new BigDecimal(String.valueOf(object));
        }
        catch (NumberFormatException ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), BigDecimal.class.getSimpleName(), object);
        }
    }

    @Override
    public byte[] convertBase64StringToByteArray(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (!(object instanceof String)) {
            throw new CantConvertException(object.getClass().getSimpleName(), byte[].class.getSimpleName(), object);
        }
        if (!this.isCanBeConvertedToByteArray(object)) {
            throw new CantConvertException(object.getClass().getSimpleName(), byte[].class.getSimpleName(), object);
        }
        try {
            return Base64.decodeBase64((String)object);
        }
        catch (Exception ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), byte[].class.getSimpleName(), object);
        }
    }

    @Override
    public String convertByteArrayToBase64String(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        return Base64.encodeBase64String(byteArray);
    }

    @Override
    public Date convertToDateFromJsonDateFormat(Object object) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        try {
            return this.getJsonManager().parseDateFromJson(String.valueOf(object));
        }
        catch (Exception ex) {
            throw new CantConvertException(object.getClass().getSimpleName(), Date.class.getSimpleName(), object);
        }
    }

    @Override
    public <T> T convertTo(Object object, Class<T> targetType) throws CantConvertException {
        if (object == null) {
            return null;
        }
        if (targetType == null) {
            throw new CantConvertException(object.getClass().getName(), "null", object);
        }
        if (targetType.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (String.class.isAssignableFrom(targetType)) {
            return (T)this.convertToString(object);
        }
        if (Integer.class.isAssignableFrom(targetType)) {
            return (T)this.convertToInteger(object);
        }
        if (Long.class.isAssignableFrom(targetType)) {
            return (T)this.convertToLong(object);
        }
        if (Float.class.isAssignableFrom(targetType)) {
            return (T)this.convertToFloat(object);
        }
        if (Double.class.isAssignableFrom(targetType)) {
            return (T)this.convertToDouble(object);
        }
        if (Boolean.class.isAssignableFrom(targetType)) {
            return (T)this.convertToBoolean(object);
        }
        if (BigDecimal.class.isAssignableFrom(targetType)) {
            return (T)this.convertToBigDecimal(object);
        }
        if (byte[].class.isAssignableFrom(targetType)) {
            return (T)this.convertBase64StringToByteArray(object);
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return (T)this.convertToDateFromJsonDateFormat(object);
        }
        if (JsonObject.class.isAssignableFrom(targetType)) {
            return (T)this.convertToJsonObject(object);
        }
        if (JsonArray.class.isAssignableFrom(targetType)) {
            return (T)this.convertToJsonArray(object);
        }
        throw new CantConvertException(object.getClass().getName(), targetType.getName(), object);
    }

    @Override
    public String convertToJsonDateFormat(Date date) {
        return this.getJsonManager().convertToJsonDate(date);
    }

    @Override
    public int compareTo(Object valueToCompare, Object compareTo) throws CantCompareException {
        if (valueToCompare == null) {
            if (compareTo == null) {
                return 0;
            }
            return -1;
        }
        if (compareTo == null) {
            return 1;
        }
        if (compareTo instanceof Comparable) {
            try {
                Object valueToCompareConverted = this.convertTo(valueToCompare, compareTo.getClass());
                int result = ((Comparable)valueToCompareConverted).compareTo(compareTo);
                return result;
            }
            catch (CantConvertException valueToCompareConverted) {
                // empty catch block
            }
        }
        if (valueToCompare instanceof Number) {
            Object compareToConverted = this.convertTo(compareTo, valueToCompare.getClass());
            int result = ((Comparable)valueToCompare).compareTo(compareToConverted);
            return result;
        }
        throw new CantCompareException(valueToCompare.getClass().getName(), compareTo.getClass().getName(), valueToCompare);
    }

    @Override
    public boolean isEquivalent(Object valueToCompare, Object compareTo) {
        if (valueToCompare == null) {
            return compareTo == null;
        }
        if (compareTo == null) {
            return false;
        }
        if (valueToCompare instanceof JsonObject && compareTo instanceof JsonObject) {
            return ((JsonObject)compareTo).isEquivalentTo((JsonObject)valueToCompare);
        }
        if (valueToCompare instanceof JsonArray && compareTo instanceof JsonArray) {
            return ((JsonArray)compareTo).isEquivalentTo((JsonArray)valueToCompare);
        }
        if (compareTo instanceof byte[] || compareTo instanceof Byte[]) {
            if (!(valueToCompare instanceof byte[]) && !(valueToCompare instanceof Byte[])) {
                try {
                    valueToCompare = this.convertTo(valueToCompare, compareTo.getClass());
                }
                catch (CantConvertException ex) {
                    return false;
                }
            }
            return Arrays.equals((byte[])valueToCompare, (byte[])compareTo);
        }
        boolean equals = compareTo.equals(valueToCompare);
        if (!equals) {
            try {
                Object valueToCompareConverted = this.convertTo(valueToCompare, compareTo.getClass());
                equals = valueToCompareConverted.equals(compareTo);
            }
            catch (CantConvertException valueToCompareConverted) {
                // empty catch block
            }
            if (!equals && valueToCompare instanceof Number) {
                try {
                    Object compareToConverted = this.convertTo(compareTo, valueToCompare.getClass());
                    equals = valueToCompare.equals(compareToConverted);
                }
                catch (CantConvertException cantConvertException) {
                    // empty catch block
                }
            }
        }
        return equals;
    }

    @Override
    public boolean isAtLeastOneEquivalentElementInCommon(Collection<?> col1, Collection<?> col2) {
        if (col1 == null || col2 == null || col1.size() == 0 || col2.size() == 0) {
            return false;
        }
        for (Object obj1 : col1) {
            for (Object obj2 : col2) {
                if (!this.isEquivalent(obj1, obj2)) continue;
                return true;
            }
        }
        return false;
    }
}

