/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import javax.annotation.Nullable;
import org.spincast.core.config.SpincastDictionary;
import org.spincast.core.json.JsonManager;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationBuilderCoreBase;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationLevel;
import org.spincast.core.validation.ValidationMessage;
import org.spincast.core.validation.ValidationSet;
import org.spincast.shaded.org.apache.commons.collections.CollectionUtils;

public abstract class ValidationBuilderCoreBaseDefault<T extends ValidationBuilderCoreBase<?>> {
    private final SpincastDictionary spincastDictionary;
    private final ValidationSet validationSet;
    private final SimpleValidator simpleValidator;
    private final String validationKey;
    private final Object elementToValidate;
    private final ValidationFactory validationFactory;
    private final JsonManager jsonManager;
    private String code;
    private boolean addMessageOnSuccess = false;
    private String successMessageText;
    private boolean treatErrorAsWarning = false;
    private String errorMessageText;

    @AssistedInject
    public ValidationBuilderCoreBaseDefault(@Assisted ValidationSet validationSet, @Assisted SimpleValidator validator, @Assisted String validationKey, @Assisted @Nullable Object elementToValidate, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager) {
        this.validationSet = validationSet;
        this.simpleValidator = validator;
        this.validationKey = validationKey;
        this.elementToValidate = elementToValidate;
        this.validationFactory = validationFactory;
        this.spincastDictionary = spincastDictionary;
        this.jsonManager = jsonManager;
    }

    protected ValidationSet getValidationSet() {
        return this.validationSet;
    }

    protected SimpleValidator getSimpleValidator() {
        return this.simpleValidator;
    }

    protected String getValidationKey() {
        return this.validationKey;
    }

    protected Object getElementToValidate() {
        return this.elementToValidate;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    protected SpincastDictionary getSpincastDictionary() {
        return this.spincastDictionary;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    public T code(String code) {
        this.code = code;
        ValidationBuilderCoreBase asT = (ValidationBuilderCoreBase)((Object)this);
        return (T)asT;
    }

    protected String getCode() {
        return this.code;
    }

    public T addMessageOnSuccess() {
        this.addMessageOnSuccess = true;
        ValidationBuilderCoreBase asT = (ValidationBuilderCoreBase)((Object)this);
        return (T)asT;
    }

    protected boolean isAddMessageOnSuccess() {
        return this.addMessageOnSuccess;
    }

    public T addMessageOnSuccess(String customSuccessMessageText) {
        this.addMessageOnSuccess = true;
        this.successMessageText = customSuccessMessageText;
        ValidationBuilderCoreBase asT = (ValidationBuilderCoreBase)((Object)this);
        return (T)asT;
    }

    protected String getSuccessMessageText() {
        return this.successMessageText;
    }

    public T treatErrorAsWarning() {
        this.treatErrorAsWarning = true;
        ValidationBuilderCoreBase asT = (ValidationBuilderCoreBase)((Object)this);
        return (T)asT;
    }

    protected ValidationLevel getFailLevel() {
        return this.isTreatErrorAsWarning() ? ValidationLevel.WARNING : ValidationLevel.ERROR;
    }

    protected boolean isTreatErrorAsWarning() {
        return this.treatErrorAsWarning;
    }

    public T failMessageText(String customErrorMessageText) {
        this.errorMessageText = customErrorMessageText;
        ValidationBuilderCoreBase asT = (ValidationBuilderCoreBase)((Object)this);
        return (T)asT;
    }

    protected String getErrorMessageText() {
        return this.errorMessageText;
    }

    public ValidationSet validate() {
        return this.validate(null);
    }

    public ValidationSet validate(boolean onlyIfNoMessageYet) {
        return this.validate(ValidationLevel.SUCCESS);
    }

    public ValidationSet validate(ValidationLevel onlyIfNoMessageAtThisLevelOrHigherYet) {
        return this.validateElement(this.getValidationKey(), this.getElementToValidate(), onlyIfNoMessageAtThisLevelOrHigherYet);
    }

    protected ValidationSet validateElement(String validationKey, Object elementToValidate, ValidationLevel onlyIfNoMessageAtThisLevelOrHigherYet) {
        ValidationLevel level;
        boolean valid;
        List<ValidationMessage> messages;
        if (onlyIfNoMessageAtThisLevelOrHigherYet != null && !CollectionUtils.isEmpty(messages = this.getValidationSet().getMessages(validationKey))) {
            if (onlyIfNoMessageAtThisLevelOrHigherYet == ValidationLevel.SUCCESS) {
                return this.getValidationFactory().createValidationSet();
            }
            for (ValidationMessage message : messages) {
                ValidationLevel level2 = message.getValidationLevel();
                if (level2 == ValidationLevel.ERROR) {
                    return this.getValidationFactory().createValidationSet();
                }
                if (level2 != ValidationLevel.WARNING || onlyIfNoMessageAtThisLevelOrHigherYet != ValidationLevel.WARNING) continue;
                return this.getValidationFactory().createValidationSet();
            }
        }
        if ((valid = this.getSimpleValidator().validate(elementToValidate)) && !this.isAddMessageOnSuccess()) {
            return this.getValidationFactory().createValidationSet();
        }
        String code = this.getCode() != null ? this.getCode() : this.getSimpleValidator().getCode();
        ValidationLevel validationLevel = level = valid ? ValidationLevel.SUCCESS : this.getFailLevel();
        String messageText = valid ? (this.getSuccessMessageText() != null ? this.getSuccessMessageText() : this.getSimpleValidator().getSuccessMessage(elementToValidate)) : (this.getErrorMessageText() != null ? this.getErrorMessageText() : this.getSimpleValidator().getFailMessage(elementToValidate));
        ValidationMessage message = this.getValidationFactory().createMessage(level, code, messageText);
        return this.getValidationSet().addMessage(validationKey, message);
    }
}

