/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.spincast.core.json.JsonArray;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationBuilderArray;
import org.spincast.core.validation.ValidationBuilderCore;
import org.spincast.core.validation.ValidationBuilderTarget;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationSet;

public class ValidationBuilderTargetDefault
implements ValidationBuilderTarget {
    private final ValidationSet validationSet;
    private final SimpleValidator validator;
    private final String validationKey;
    private final ValidationFactory validationFactory;

    @AssistedInject
    public ValidationBuilderTargetDefault(@Assisted ValidationSet validationSet, @Assisted SimpleValidator validator, @Assisted String validationKey, ValidationFactory validationFactory) {
        this.validationSet = validationSet;
        this.validator = validator;
        this.validationKey = validationKey;
        this.validationFactory = validationFactory;
    }

    protected ValidationSet getValidationSet() {
        return this.validationSet;
    }

    protected SimpleValidator getValidator() {
        return this.validator;
    }

    protected String getValidationKey() {
        return this.validationKey;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    @Override
    public ValidationBuilderCore element(Object element) {
        return this.getValidationFactory().createValidationBuilderCore(this.getValidationSet(), this.getValidator(), this.getValidationKey(), element);
    }

    @Override
    public ValidationBuilderArray all(JsonArray array) {
        return this.getValidationFactory().createValidationBuilderArray(this.getValidationSet(), this.getValidator(), this.getValidationKey(), array);
    }
}

